% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcols.R
\name{hcols}
\alias{hcols}
\title{Aesthetically pleasing color ramp for plotting habitat suitability}
\usage{
hcols(x, bias = 1)
}
\arguments{
\item{x}{number of colors to return}

\item{bias}{a positive number. Higher values give more widely spaced colors at the high end (as in \link{colorRampPalette}).}
}
\value{
Returns a character vector of colors (see \code{\link{rgb}}) interpolating 
the given sequence (similar to \code{\link{heat.colors}} or \code{\link{terrain.colors}}.
}
\description{
Aesthetically pleasing color ramp for plotting habitat suitability
}
\examples{
library(ggplot2)
data=cbind.data.frame(expand.grid(x=1:10,y=1:10),z=rnorm(100))
ggplot(data,aes(x=x,y=y,fill=z))+geom_raster()+
scale_fill_gradientn(colours=hcols(20,bias=2))
}

