% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compress.R
\name{compress}
\alias{compress}
\alias{rtrans}
\alias{unrtrans}
\title{Compress maxent output by converting from ASCII file to compressed geotif}
\usage{
compress(file, fun = rtrans)

rtrans(x)

unrtrans(x)
}
\arguments{
\item{file}{\code{character} path to file to be compressed}

\item{fun}{Function to use to compress the data.  Default is \code{rtrans()}, which is \code{round(log(x)*100}.}

\item{x}{value passed to \code{rtrans} or \code{untrans} for conversion.}

\item{...}{additional functions to be passed to \code{writeRaster()}}
}
\value{
Returns the converted file as a raster() object
}
\description{
Maxent writes out ASCII files that are uncompressed. This function transforms the data, converts it to a compressed
geotif, and deletes the original.  The default transform \code{rtrans} is to take the \eqn{round(log(x)*100)}.
Note that this conversion may be lossy depending on the transform applied.
}
\section{Functions}{
\itemize{
\item \code{rtrans}: transform data to faciliate storing as an integer as \eqn{round(log(x)*100)}.

\item \code{unrtrans}: uncompress data transformed with \code{rtrans}
}}

