% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CheckRates.R
\name{checkRates}
\alias{checkRates}
\title{Evaluate whether potential curve parameters are feasible given the range and domain geometry.}
\usage{
checkRates(rdist, dists = NULL, prob = seq(0.1, 1, len = 10),
  rate = exp(seq(log(0.01), log(10), len = 10)), skew = c(0.2), shift = 0,
  verbose = T, plot = T)
}
\arguments{
\item{rdist}{\code{raster*} object of distances to the range edge (output from \code{\link{rangeDist}}}

\item{dists}{frequency table of unique distance values (output from running \code{\link[raster]{freq}} on the \code{rdist} object).
If NULL, it will be created within the function but can also be supplied here to speed up processing multiple logistic parameters}

\item{prob}{vector of "probability inside" values to consider}

\item{rate}{vector of rate values to consider}

\item{skew}{vector of skew values to consider}

\item{shift}{vector of shift values to consider}

\item{verbose}{logical indicating whether to print verbose messages}

\item{plot}{logical indicating whether to draw a plot of desired probability vs. decay rate.}
}
\value{
dataframe of fitted parameters for each parameter combination provided with prob, rate, skew, and shift.
}
\description{
Note that parallelization is supported to expedite evaluation; see examples
}
\examples{
data(Beamys_hindei_range)
# Generate domain
 domain=raster::raster(xmn=-180, xmx=180, ymn=-90, ymx=90,
 crs="+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs",
 resolution=.1, vals=NULL)
 # registerDoParallel(2) #optionally use to speed up calculation
 # Calculate distance to range
 rdist=rangeDist(range=Beamys_hindei_range,domain=domain,
                 domainkm=1000,mask=FALSE,fact=2,verbose=FALSE)
 dpar=checkRates(rdist,plot=FALSE)
 head(dpar)
}

