% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitDistributionsToCIs.R
\name{getNormFromCI}
\alias{getNormFromCI}
\title{Find the best-fit normal / Gaussian distribution for a given confidence interval.}
\usage{
getNormFromCI(qLow, qUpp, alpha = 0.05, initPars = c(0, 1), maxiter = 1000)
}
\arguments{
\item{qLow}{The observed lower quantile.}

\item{qUpp}{The observed upper quantile.}

\item{alpha}{The confidence level; i.e. the desired coverage is 1-alpha. Defaults to 0.05.}

\item{initPars}{A vector of length 2 giving the initial parameter values (mean & sd) to start the optimisation; defaults to c(0,1).}

\item{maxiter}{Maximum number of iterations for \code{optim}. Defaults to 1e3. Set to higher values if convergence problems are reported.}
}
\value{
A list with 5 elements:
\item{r}{The sampling function.}
\item{d}{The density function.}
\item{p}{The distribution function.}
\item{q}{The quantile function.}
\item{pars}{A vector of length 2 giving the mean and standard deviation for the best-fit normal distribution (\code{mean} and \code{sd} as in \code{\link{rnorm}}, \code{\link{dnorm}}, \code{\link{pnorm}}, \code{\link{qnorm}}).}
}
\description{
Finds the best-fit normal distribution for a given confidence interval; returns the corresponding density, distribution, quantile and sampling functions.
}
\examples{
n<-getNormFromCI(qLow=1.08,qUpp=8.92)
print(n$pars) # the fitted parameter values (mean & sd)
n$r(10) # 10 random values from the fitted normal distribution
n$d(6) # the probability density at x=6 for the normal distribution
n$p(4.25) # the cumulative density at x=4.25 for the fitted normal distribution
n$q(c(0.25,0.5,0.75)) # the 25th, 50th (median) and 75th percentiles of the fitted distribution
x<-seq(0,10,length=1e3)
y<-n$d(x)
plot(x,y,type="l",xlab="",ylab="density") # density plot for the fitted normal distribution

}
\seealso{
\code{\link{identifyNormPars}}, \code{\link{optim}}, \code{\link{dnorm}}
}
