% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/horseshoe.R
\name{horseshoe}
\alias{horseshoe}
\title{Bayesian Shrinkage Model Estimation}
\usage{
horseshoe(
  resp,
  trt,
  subgr,
  covars,
  data,
  resptype = c("survival", "binary"),
  status = NULL,
  ...
)
}
\arguments{
\item{resp}{(\code{string})\cr the response variable name.}

\item{trt}{(\code{string})\cr the treatment variable name.The treatment variable
must be a factor with 2 levels where the first level is the control and the
second one the treatment.}

\item{subgr}{(\code{character})\cr vector with the name of the subgroup variables
from which we want to obtain the subgroup treatment effect. They have to be
\code{factor} variables with the subgroups as levels.}

\item{covars}{(\code{character})\cr vector with the name of the variables that
we want to include in the model. They have to be \code{factor} variables with the
subgroups as levels. The \code{subgr} variables have to be included here.}

\item{data}{(\verb{data frame})\cr the data frame with the variables.}

\item{resptype}{(\code{string})\cr the type of data used. Can be "survival"
or "binary".}

\item{status}{(\code{string})\cr only for "survival" \code{resptype},
the status variable name in survival data.}

\item{...}{Additional arguments from the \code{brm} function.}
}
\value{
List with \code{fit}, \code{model}, \code{resptype}, \code{data}, \code{alpha},
\code{design_matrix}, \code{design_dummy}, \code{y}, \code{subgr_names}.
}
\description{
Function to fit a bayesian shrinkage model with a regularized horseshoe prior
on the interaction coefficients between the subgrouping covariates and
the treatment.
}
\examples{
\donttest{
horseshoe("ev_pfs", "arm", c("x_1", "x_2"), c("x_1", "x_2", "x_3"),
  example_data, "binary",
  chains = 1, seed = 0, control = list(adapt_delta = 0.95),
  iter = 50 # In practice, you need to omit this or set it much higher!
)
}
}
