% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractByMask.R
\name{extractByMask}
\alias{extractByMask}
\title{Extract raster values by mask}
\usage{
extractByMask(rast, msk, spatial = FALSE)
}
\arguments{
\item{rast}{an object of class "RasterLayer" (package \href{https://cran.r-project.org/package=raster}{raster}). The raster from which data will be extracted}

\item{msk}{an object of class "RasterLayer" or a two column matrix of coordinates. The reference raster (or coordinates) to be used as mask for extraction.}

\item{spatial}{logical. Should the output be spatially explicit -i.e. a georeferenced raster? 
Default is FALSE, returning a vector of extracted values from \code{rast}. 
If TRUE an object of class "RasterLayer" is returned.}
}
\value{
a vector, or an object of class "RasterLayer". The values from the input raster (\code{rast} argument) at coordinates provided as matrix, or those overlapping with non NA cells in the mask raster. If \code{spatial == TRUE} an object of class "RasterLayer" is returned.
}
\description{
This function extracts the values from a given input raster based on a mask.
}
\details{
When input data given to \code{rast} does not match the resolution and extent of a raster mask argument, the latter is preferred. The function will therefore return a vector of n elements, one for each non NA cell in the mask. Input raster cells falling inside mask cells, but not over their cells centre will be ignored.
}
\examples{
data(ConwyData)
m <- aoi(msk=ConwyLU, mskSub=c(2,3))
head( extractByMask(ConwySlope, msk=m), 20) 

# Extract making a raster
library(raster)
plot( extractByMask(ConwySlope, msk=m, spatial=TRUE) )
}
\seealso{
\code{\link{aoi}}
}

