% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.type.score.R
\name{check.type.score}
\alias{check.type.score}
\title{Return the type of score needed to be used with Bayesian Networks learning algorithms.}
\usage{
check.type.score(type.variable)
}
\arguments{
\item{type.variable}{A variable with the code of types: 1=integer, 2=numeric, 3=factor,
 4=integer and numeric, 5=integer and  factor, 6=numeric and factor,
7=integer, numeric and factor.}
}
\value{
type of score.
}
\description{
Verify what kind of variable data has and return a type of score needed to be used with 
Bayesian Networks learning algorithms.
}
\details{
This function receives a variable with the type of data in a dataset and return a type
of score needed to learn the Bayesian Networks structure.
}
\examples{
# Clean environment
closeAllConnections()
rm(list=ls())
# Load packages
library(bnpa)
################################################################################################
# check.types.score.R - Return the type of score needed to be used with Bayesian Networks 
# learning algorithms.
################################################################################################
# Load quantitative data
data.to.work <- dataQuantC
head(data.to.work)
# Check and return a numeric value
type.variable <- check.types(data.to.work)
# Check the type of score
check.type.score(type.variable)
# Load qualitative data
data.to.work <- dataQualiN
head(data.to.work)
# Check and return a numeric value
type.variable <- check.types(data.to.work)
# Check the type of score
check.type.score(type.variable)
}
\author{
Elias Carvalho
}

