% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMSC-plot.R
\name{pp_check.BMSC}
\alias{pp_check.BMSC}
\title{Posterior predictive check for BMSC objects}
\usage{
\method{pp_check}{BMSC}(object, type = "dens", limited = FALSE, ...)
}
\arguments{
\item{object}{a \link{BMSC} object}

\item{type}{a parameter to select the typology of graph
\describe{
        \item{dens}{density overlay plot}
        \item{hist}{histogram plot}
        \item{mode}{the distribution of the mode statistic, over the simulated datasets, compared to the mode of the real data}
}}

\item{limited}{logical. TRUE if the output should be limited within the 95\% credible interval, FALSE it should not. Default FALSE.}

\item{...}{other arguments are ignored.}
}
\value{
a ggplot2 object
}
\description{
\code{pp_check()} plots the posterior predictive check for BMSC objects.
}
\examples{
 \donttest{
# simulation of healthy controls data

Sigma.ctrl <- matrix(cbind(1, .7,  .7, 1) ,nrow=2)

U <- t(chol(Sigma.ctrl))

numobs <- 100

set.seed(123)

random.normal <- matrix( rnorm( n = ncol(U) * numobs, mean = 3, sd = 1),
                         nrow = ncol(U), ncol = numobs)

X = U \%*\% random.normal

dat.ctrl <- as.data.frame(t(X))

names(dat.ctrl) <- c("y","x")

cor(dat.ctrl)

# simulation of patient data

Sigma.pt <- matrix(cbind(1, 0,  0, 1) ,nrow=2)

U <- t(chol(Sigma.pt))

numobs <- 20

set.seed(0)

random.normal <- matrix( rnorm( n = ncol(U) * numobs, mean = 3, sd = 1),
                 nrow = ncol(U), ncol = numobs)

X = U \%*\% random.normal

dat.pt <- as.data.frame(t(X))

names(dat.pt) <- c("y","x")

cor(dat.pt)

# fit the single case model

mdl.reg <- BMSC(y ~ x, data_ctrl = dat.ctrl, data_sc = dat.pt, seed = 10)

# summarize the data

summary(mdl.reg)

# plot the posterior predictive checks

pp_check(mdl.reg, limited = FALSE)

pp_check(mdl.reg, limited = TRUE)

pp_check(mdl.reg, type = "mode", limited = FALSE)

pp_check(mdl.reg, type = "hist", limited = FALSE)
}

}
