// Generated by rstantools.  Do not edit by hand.

/*
    bmgarch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bmgarch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bmgarch.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_forecastCCC_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_forecastCCC");
    reader.add_event(1, 1, "include", "/data/gq_data.stan");
    reader.add_event(1, 0, "start", "/data/gq_data.stan");
    reader.add_event(13, 12, "end", "/data/gq_data.stan");
    reader.add_event(13, 2, "restart", "model_forecastCCC");
    reader.add_event(17, 6, "include", "/transformed_data/xh_marker.stan");
    reader.add_event(17, 0, "start", "/transformed_data/xh_marker.stan");
    reader.add_event(29, 12, "end", "/transformed_data/xh_marker.stan");
    reader.add_event(29, 7, "restart", "model_forecastCCC");
    reader.add_event(40, 18, "include", "/parameters/arma.stan");
    reader.add_event(40, 0, "start", "/parameters/arma.stan");
    reader.add_event(47, 7, "end", "/parameters/arma.stan");
    reader.add_event(47, 19, "restart", "model_forecastCCC");
    reader.add_event(48, 20, "include", "/parameters/predH.stan");
    reader.add_event(48, 0, "start", "/parameters/predH.stan");
    reader.add_event(52, 4, "end", "/parameters/predH.stan");
    reader.add_event(52, 21, "restart", "model_forecastCCC");
    reader.add_event(147, 116, "include", "/generated/forecast_sampling.stan");
    reader.add_event(147, 0, "start", "/generated/forecast_sampling.stan");
    reader.add_event(152, 5, "end", "/generated/forecast_sampling.stan");
    reader.add_event(152, 117, "restart", "model_forecastCCC");
    reader.add_event(172, 137, "include", "/generated/forecast_log_lik.stan");
    reader.add_event(172, 0, "start", "/generated/forecast_log_lik.stan");
    reader.add_event(183, 11, "end", "/generated/forecast_log_lik.stan");
    reader.add_event(183, 138, "restart", "model_forecastCCC");
    reader.add_event(186, 139, "end", "model_forecastCCC");
    return reader;
}
#include <stan_meta_header.hpp>
class model_forecastCCC
  : public stan::model::model_base_crtp<model_forecastCCC> {
private:
        int T;
        int nt;
        int Q;
        int P;
        std::vector<vector_d> rts;
        std::vector<vector_d> xC;
        int distribution;
        int meanstructure;
        int ahead;
        std::vector<vector_d> xC_p;
        std::vector<vector_d> future_rts;
        int compute_log_lik;
        matrix_d xC_c;
        std::vector<matrix_d> xC_m;
        int xC_marker;
        double cp;
public:
    model_forecastCCC(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_forecastCCC(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_forecastCCC_namespace::model_forecastCCC";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            check_greater_or_equal(function__, "T", T, 2);
            current_statement_begin__ = 3;
            context__.validate_dims("data initialization", "nt", "int", context__.to_vec());
            nt = int(0);
            vals_i__ = context__.vals_i("nt");
            pos__ = 0;
            nt = vals_i__[pos__++];
            check_greater_or_equal(function__, "nt", nt, 2);
            current_statement_begin__ = 4;
            context__.validate_dims("data initialization", "Q", "int", context__.to_vec());
            Q = int(0);
            vals_i__ = context__.vals_i("Q");
            pos__ = 0;
            Q = vals_i__[pos__++];
            check_greater_or_equal(function__, "Q", Q, 1);
            current_statement_begin__ = 5;
            context__.validate_dims("data initialization", "P", "int", context__.to_vec());
            P = int(0);
            vals_i__ = context__.vals_i("P");
            pos__ = 0;
            P = vals_i__[pos__++];
            check_greater_or_equal(function__, "P", P, 1);
            current_statement_begin__ = 6;
            validate_non_negative_index("rts", "nt", nt);
            validate_non_negative_index("rts", "T", T);
            context__.validate_dims("data initialization", "rts", "vector_d", context__.to_vec(T,nt));
            rts = std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> >(T, Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
            vals_r__ = context__.vals_r("rts");
            pos__ = 0;
            size_t rts_j_1_max__ = nt;
            size_t rts_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < rts_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < rts_k_0_max__; ++k_0__) {
                    rts[k_0__](j_1__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 7;
            validate_non_negative_index("xC", "nt", nt);
            validate_non_negative_index("xC", "T", T);
            context__.validate_dims("data initialization", "xC", "vector_d", context__.to_vec(T,nt));
            xC = std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> >(T, Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
            vals_r__ = context__.vals_r("xC");
            pos__ = 0;
            size_t xC_j_1_max__ = nt;
            size_t xC_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < xC_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < xC_k_0_max__; ++k_0__) {
                    xC[k_0__](j_1__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 8;
            context__.validate_dims("data initialization", "distribution", "int", context__.to_vec());
            distribution = int(0);
            vals_i__ = context__.vals_i("distribution");
            pos__ = 0;
            distribution = vals_i__[pos__++];
            check_greater_or_equal(function__, "distribution", distribution, 0);
            check_less_or_equal(function__, "distribution", distribution, 1);
            current_statement_begin__ = 9;
            context__.validate_dims("data initialization", "meanstructure", "int", context__.to_vec());
            meanstructure = int(0);
            vals_i__ = context__.vals_i("meanstructure");
            pos__ = 0;
            meanstructure = vals_i__[pos__++];
            check_greater_or_equal(function__, "meanstructure", meanstructure, 0);
            check_less_or_equal(function__, "meanstructure", meanstructure, 2);
            current_statement_begin__ = 10;
            context__.validate_dims("data initialization", "ahead", "int", context__.to_vec());
            ahead = int(0);
            vals_i__ = context__.vals_i("ahead");
            pos__ = 0;
            ahead = vals_i__[pos__++];
            check_greater_or_equal(function__, "ahead", ahead, 1);
            current_statement_begin__ = 11;
            validate_non_negative_index("xC_p", "nt", nt);
            validate_non_negative_index("xC_p", "ahead", ahead);
            context__.validate_dims("data initialization", "xC_p", "vector_d", context__.to_vec(ahead,nt));
            xC_p = std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> >(ahead, Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
            vals_r__ = context__.vals_r("xC_p");
            pos__ = 0;
            size_t xC_p_j_1_max__ = nt;
            size_t xC_p_k_0_max__ = ahead;
            for (size_t j_1__ = 0; j_1__ < xC_p_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < xC_p_k_0_max__; ++k_0__) {
                    xC_p[k_0__](j_1__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 12;
            validate_non_negative_index("future_rts", "nt", nt);
            validate_non_negative_index("future_rts", "ahead", ahead);
            context__.validate_dims("data initialization", "future_rts", "vector_d", context__.to_vec(ahead,nt));
            future_rts = std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> >(ahead, Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
            vals_r__ = context__.vals_r("future_rts");
            pos__ = 0;
            size_t future_rts_j_1_max__ = nt;
            size_t future_rts_k_0_max__ = ahead;
            for (size_t j_1__ = 0; j_1__ < future_rts_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < future_rts_k_0_max__; ++k_0__) {
                    future_rts[k_0__](j_1__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 13;
            context__.validate_dims("data initialization", "compute_log_lik", "int", context__.to_vec());
            compute_log_lik = int(0);
            vals_i__ = context__.vals_i("compute_log_lik");
            pos__ = 0;
            compute_log_lik = vals_i__[pos__++];
            check_greater_or_equal(function__, "compute_log_lik", compute_log_lik, 0);
            check_less_or_equal(function__, "compute_log_lik", compute_log_lik, 1);
            // initialize transformed data variables
            current_statement_begin__ = 17;
            validate_non_negative_index("xC_c", "(ahead + std::max(Q, P))", (ahead + std::max(Q, P)));
            validate_non_negative_index("xC_c", "nt", nt);
            xC_c = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((ahead + std::max(Q, P)), nt);
            stan::math::fill(xC_c, DUMMY_VAR__);
            current_statement_begin__ = 19;
            validate_non_negative_index("xC_m", "nt", nt);
            validate_non_negative_index("xC_m", "nt", nt);
            validate_non_negative_index("xC_m", "T", T);
            xC_m = std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> >(T, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
            stan::math::fill(xC_m, DUMMY_VAR__);
            current_statement_begin__ = 20;
            xC_marker = int(0);
            stan::math::fill(xC_marker, std::numeric_limits<int>::min());
            stan::math::assign(xC_marker,0);
            current_statement_begin__ = 21;
            cp = double(0);
            stan::math::fill(cp, DUMMY_VAR__);
            // execute transformed data statements
            current_statement_begin__ = 23;
            for (int t = 1; t <= T; ++t) {
                current_statement_begin__ = 24;
                stan::model::assign(xC_m, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            diag_matrix(get_base1(xC, t, "xC", 1)), 
                            "assigning variable xC_m");
                current_statement_begin__ = 26;
                stan::math::assign(cp, sum(multiply(transpose(get_base1(xC_m, t, "xC_m", 1)), get_base1(xC_m, t, "xC_m", 1))));
                current_statement_begin__ = 27;
                if (as_bool(logical_neq(cp, 0))) {
                    current_statement_begin__ = 28;
                    stan::math::assign(xC_marker, (xC_marker + 1));
                }
            }
            current_statement_begin__ = 31;
            for (int i = 1; i <= std::max(Q, P); ++i) {
                current_statement_begin__ = 32;
                stan::model::assign(xC_c, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            transpose(get_base1(xC, (T - (std::max(Q, P) - 1)), "xC", 1)), 
                            "assigning variable xC_c");
            }
            current_statement_begin__ = 34;
            for (int i = 1; i <= ahead; ++i) {
                current_statement_begin__ = 35;
                stan::model::assign(xC_c, 
                            stan::model::cons_list(stan::model::index_uni((i + std::max(Q, P))), stan::model::nil_index_list()), 
                            transpose(get_base1(xC_p, i, "xC_p", 1)), 
                            "assigning variable xC_c");
            }
            // validate transformed data
            current_statement_begin__ = 20;
            check_greater_or_equal(function__, "xC_marker", xC_marker, 0);
            current_statement_begin__ = 21;
            check_greater_or_equal(function__, "cp", cp, 0);
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 41;
            validate_non_negative_index("phi0", "nt", nt);
            num_params_r__ += nt;
            current_statement_begin__ = 46;
            validate_non_negative_index("phi", "nt", nt);
            validate_non_negative_index("phi", "nt", nt);
            num_params_r__ += (nt * nt);
            current_statement_begin__ = 47;
            validate_non_negative_index("theta", "nt", nt);
            validate_non_negative_index("theta", "nt", nt);
            num_params_r__ += (nt * nt);
            current_statement_begin__ = 52;
            validate_non_negative_index("beta", "nt", nt);
            num_params_r__ += nt;
            current_statement_begin__ = 54;
            num_params_r__ += 1;
            current_statement_begin__ = 58;
            validate_non_negative_index("c_h", "nt", nt);
            num_params_r__ += nt;
            current_statement_begin__ = 59;
            validate_non_negative_index("a_h", "nt", nt);
            validate_non_negative_index("a_h", "Q", Q);
            num_params_r__ += (nt * Q);
            current_statement_begin__ = 60;
            validate_non_negative_index("b_h", "nt", nt);
            validate_non_negative_index("b_h", "P", P);
            num_params_r__ += (nt * P);
            current_statement_begin__ = 63;
            validate_non_negative_index("R", "nt", nt);
            validate_non_negative_index("R", "nt", nt);
            num_params_r__ += ((nt * (nt - 1)) / 2);
            current_statement_begin__ = 66;
            validate_non_negative_index("D1_init", "nt", nt);
            num_params_r__ += nt;
            current_statement_begin__ = 68;
            validate_non_negative_index("H", "nt", nt);
            validate_non_negative_index("H", "nt", nt);
            validate_non_negative_index("H", "T", T);
            num_params_r__ += ((nt + ((nt * (nt - 1)) / 2)) * T);
            current_statement_begin__ = 69;
            validate_non_negative_index("rr", "nt", nt);
            validate_non_negative_index("rr", "(T - 1)", (T - 1));
            num_params_r__ += (nt * (T - 1));
            current_statement_begin__ = 70;
            validate_non_negative_index("mu", "nt", nt);
            validate_non_negative_index("mu", "T", T);
            num_params_r__ += (nt * T);
            current_statement_begin__ = 71;
            validate_non_negative_index("D", "nt", nt);
            validate_non_negative_index("D", "T", T);
            num_params_r__ += (nt * T);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_forecastCCC() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 41;
        if (!(context__.contains_r("phi0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable phi0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("phi0");
        pos__ = 0U;
        validate_non_negative_index("phi0", "nt", nt);
        context__.validate_dims("parameter initialization", "phi0", "vector_d", context__.to_vec(nt));
        Eigen::Matrix<double, Eigen::Dynamic, 1> phi0(nt);
        size_t phi0_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < phi0_j_1_max__; ++j_1__) {
            phi0(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(phi0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable phi0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 46;
        if (!(context__.contains_r("phi")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable phi missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("phi");
        pos__ = 0U;
        validate_non_negative_index("phi", "nt", nt);
        validate_non_negative_index("phi", "nt", nt);
        context__.validate_dims("parameter initialization", "phi", "matrix_d", context__.to_vec(nt,nt));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> phi(nt, nt);
        size_t phi_j_2_max__ = nt;
        size_t phi_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < phi_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                phi(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_lub_unconstrain(-(1), 1, phi);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable phi: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 47;
        if (!(context__.contains_r("theta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable theta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("theta");
        pos__ = 0U;
        validate_non_negative_index("theta", "nt", nt);
        validate_non_negative_index("theta", "nt", nt);
        context__.validate_dims("parameter initialization", "theta", "matrix_d", context__.to_vec(nt,nt));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> theta(nt, nt);
        size_t theta_j_2_max__ = nt;
        size_t theta_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < theta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                theta(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_lub_unconstrain(-(1), 1, theta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable theta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 52;
        if (!(context__.contains_r("beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        validate_non_negative_index("beta", "nt", nt);
        context__.validate_dims("parameter initialization", "beta", "vector_d", context__.to_vec(nt));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta(nt);
        size_t beta_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            beta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 54;
        if (!(context__.contains_r("nu")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable nu missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("nu");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "nu", "double", context__.to_vec());
        double nu(0);
        nu = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(2, nu);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable nu: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 58;
        if (!(context__.contains_r("c_h")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable c_h missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("c_h");
        pos__ = 0U;
        validate_non_negative_index("c_h", "nt", nt);
        context__.validate_dims("parameter initialization", "c_h", "vector_d", context__.to_vec(nt));
        Eigen::Matrix<double, Eigen::Dynamic, 1> c_h(nt);
        size_t c_h_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < c_h_j_1_max__; ++j_1__) {
            c_h(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(c_h);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable c_h: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 59;
        if (!(context__.contains_r("a_h")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable a_h missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("a_h");
        pos__ = 0U;
        validate_non_negative_index("a_h", "nt", nt);
        validate_non_negative_index("a_h", "Q", Q);
        context__.validate_dims("parameter initialization", "a_h", "vector_d", context__.to_vec(Q,nt));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > a_h(Q, Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
        size_t a_h_j_1_max__ = nt;
        size_t a_h_k_0_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < a_h_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < a_h_k_0_max__; ++k_0__) {
                a_h[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t a_h_i_0_max__ = Q;
        for (size_t i_0__ = 0; i_0__ < a_h_i_0_max__; ++i_0__) {
            try {
                writer__.vector_lub_unconstrain(0, 1, a_h[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable a_h: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 60;
        if (!(context__.contains_r("b_h")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable b_h missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("b_h");
        pos__ = 0U;
        validate_non_negative_index("b_h", "nt", nt);
        validate_non_negative_index("b_h", "P", P);
        context__.validate_dims("parameter initialization", "b_h", "vector_d", context__.to_vec(P,nt));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > b_h(P, Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
        size_t b_h_j_1_max__ = nt;
        size_t b_h_k_0_max__ = P;
        for (size_t j_1__ = 0; j_1__ < b_h_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < b_h_k_0_max__; ++k_0__) {
                b_h[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t b_h_i_0_max__ = P;
        for (size_t i_0__ = 0; i_0__ < b_h_i_0_max__; ++i_0__) {
            try {
                writer__.vector_lub_unconstrain(0, 1, b_h[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable b_h: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 63;
        if (!(context__.contains_r("R")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable R missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("R");
        pos__ = 0U;
        validate_non_negative_index("R", "nt", nt);
        validate_non_negative_index("R", "nt", nt);
        context__.validate_dims("parameter initialization", "R", "matrix_d", context__.to_vec(nt,nt));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> R(nt, nt);
        size_t R_j_2_max__ = nt;
        size_t R_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < R_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < R_j_1_max__; ++j_1__) {
                R(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.corr_matrix_unconstrain(R);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable R: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 66;
        if (!(context__.contains_r("D1_init")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable D1_init missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("D1_init");
        pos__ = 0U;
        validate_non_negative_index("D1_init", "nt", nt);
        context__.validate_dims("parameter initialization", "D1_init", "vector_d", context__.to_vec(nt));
        Eigen::Matrix<double, Eigen::Dynamic, 1> D1_init(nt);
        size_t D1_init_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < D1_init_j_1_max__; ++j_1__) {
            D1_init(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, D1_init);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable D1_init: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 68;
        if (!(context__.contains_r("H")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable H missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("H");
        pos__ = 0U;
        validate_non_negative_index("H", "nt", nt);
        validate_non_negative_index("H", "nt", nt);
        validate_non_negative_index("H", "T", T);
        context__.validate_dims("parameter initialization", "H", "matrix_d", context__.to_vec(T,nt,nt));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > H(T, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
        size_t H_j_2_max__ = nt;
        size_t H_j_1_max__ = nt;
        size_t H_k_0_max__ = T;
        for (size_t j_2__ = 0; j_2__ < H_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < H_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < H_k_0_max__; ++k_0__) {
                    H[k_0__](j_1__, j_2__) = vals_r__[pos__++];
                }
            }
        }
        size_t H_i_0_max__ = T;
        for (size_t i_0__ = 0; i_0__ < H_i_0_max__; ++i_0__) {
            try {
                writer__.cov_matrix_unconstrain(H[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable H: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 69;
        if (!(context__.contains_r("rr")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rr missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rr");
        pos__ = 0U;
        validate_non_negative_index("rr", "nt", nt);
        validate_non_negative_index("rr", "(T - 1)", (T - 1));
        context__.validate_dims("parameter initialization", "rr", "vector_d", context__.to_vec((T - 1),nt));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > rr((T - 1), Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
        size_t rr_j_1_max__ = nt;
        size_t rr_k_0_max__ = (T - 1);
        for (size_t j_1__ = 0; j_1__ < rr_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < rr_k_0_max__; ++k_0__) {
                rr[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t rr_i_0_max__ = (T - 1);
        for (size_t i_0__ = 0; i_0__ < rr_i_0_max__; ++i_0__) {
            try {
                writer__.vector_unconstrain(rr[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rr: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 70;
        if (!(context__.contains_r("mu")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu");
        pos__ = 0U;
        validate_non_negative_index("mu", "nt", nt);
        validate_non_negative_index("mu", "T", T);
        context__.validate_dims("parameter initialization", "mu", "vector_d", context__.to_vec(T,nt));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > mu(T, Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
        size_t mu_j_1_max__ = nt;
        size_t mu_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
                mu[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t mu_i_0_max__ = T;
        for (size_t i_0__ = 0; i_0__ < mu_i_0_max__; ++i_0__) {
            try {
                writer__.vector_unconstrain(mu[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 71;
        if (!(context__.contains_r("D")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable D missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("D");
        pos__ = 0U;
        validate_non_negative_index("D", "nt", nt);
        validate_non_negative_index("D", "T", T);
        context__.validate_dims("parameter initialization", "D", "vector_d", context__.to_vec(T,nt));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > D(T, Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
        size_t D_j_1_max__ = nt;
        size_t D_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < D_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < D_k_0_max__; ++k_0__) {
                D[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t D_i_0_max__ = T;
        for (size_t i_0__ = 0; i_0__ < D_i_0_max__; ++i_0__) {
            try {
                writer__.vector_unconstrain(D[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable D: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 41;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> phi0;
            (void) phi0;  // dummy to suppress unused var warning
            if (jacobian__)
                phi0 = in__.vector_constrain(nt, lp__);
            else
                phi0 = in__.vector_constrain(nt);
            current_statement_begin__ = 46;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> phi;
            (void) phi;  // dummy to suppress unused var warning
            if (jacobian__)
                phi = in__.matrix_lub_constrain(-(1), 1, nt, nt, lp__);
            else
                phi = in__.matrix_lub_constrain(-(1), 1, nt, nt);
            current_statement_begin__ = 47;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> theta;
            (void) theta;  // dummy to suppress unused var warning
            if (jacobian__)
                theta = in__.matrix_lub_constrain(-(1), 1, nt, nt, lp__);
            else
                theta = in__.matrix_lub_constrain(-(1), 1, nt, nt);
            current_statement_begin__ = 52;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.vector_constrain(nt, lp__);
            else
                beta = in__.vector_constrain(nt);
            current_statement_begin__ = 54;
            local_scalar_t__ nu;
            (void) nu;  // dummy to suppress unused var warning
            if (jacobian__)
                nu = in__.scalar_lb_constrain(2, lp__);
            else
                nu = in__.scalar_lb_constrain(2);
            current_statement_begin__ = 58;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> c_h;
            (void) c_h;  // dummy to suppress unused var warning
            if (jacobian__)
                c_h = in__.vector_constrain(nt, lp__);
            else
                c_h = in__.vector_constrain(nt);
            current_statement_begin__ = 59;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > a_h;
            size_t a_h_d_0_max__ = Q;
            a_h.reserve(a_h_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < a_h_d_0_max__; ++d_0__) {
                if (jacobian__)
                    a_h.push_back(in__.vector_lub_constrain(0, 1, nt, lp__));
                else
                    a_h.push_back(in__.vector_lub_constrain(0, 1, nt));
            }
            current_statement_begin__ = 60;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > b_h;
            size_t b_h_d_0_max__ = P;
            b_h.reserve(b_h_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < b_h_d_0_max__; ++d_0__) {
                if (jacobian__)
                    b_h.push_back(in__.vector_lub_constrain(0, 1, nt, lp__));
                else
                    b_h.push_back(in__.vector_lub_constrain(0, 1, nt));
            }
            current_statement_begin__ = 63;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> R;
            (void) R;  // dummy to suppress unused var warning
            if (jacobian__)
                R = in__.corr_matrix_constrain(nt, lp__);
            else
                R = in__.corr_matrix_constrain(nt);
            current_statement_begin__ = 66;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> D1_init;
            (void) D1_init;  // dummy to suppress unused var warning
            if (jacobian__)
                D1_init = in__.vector_lb_constrain(0, nt, lp__);
            else
                D1_init = in__.vector_lb_constrain(0, nt);
            current_statement_begin__ = 68;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > H;
            size_t H_d_0_max__ = T;
            H.reserve(H_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < H_d_0_max__; ++d_0__) {
                if (jacobian__)
                    H.push_back(in__.cov_matrix_constrain(nt, lp__));
                else
                    H.push_back(in__.cov_matrix_constrain(nt));
            }
            current_statement_begin__ = 69;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > rr;
            size_t rr_d_0_max__ = (T - 1);
            rr.reserve(rr_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < rr_d_0_max__; ++d_0__) {
                if (jacobian__)
                    rr.push_back(in__.vector_constrain(nt, lp__));
                else
                    rr.push_back(in__.vector_constrain(nt));
            }
            current_statement_begin__ = 70;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > mu;
            size_t mu_d_0_max__ = T;
            mu.reserve(mu_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < mu_d_0_max__; ++d_0__) {
                if (jacobian__)
                    mu.push_back(in__.vector_constrain(nt, lp__));
                else
                    mu.push_back(in__.vector_constrain(nt));
            }
            current_statement_begin__ = 71;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > D;
            size_t D_d_0_max__ = T;
            D.reserve(D_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < D_d_0_max__; ++d_0__) {
                if (jacobian__)
                    D.push_back(in__.vector_constrain(nt, lp__));
                else
                    D.push_back(in__.vector_constrain(nt));
            }
            // model body
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("phi0");
        names__.push_back("phi");
        names__.push_back("theta");
        names__.push_back("beta");
        names__.push_back("nu");
        names__.push_back("c_h");
        names__.push_back("a_h");
        names__.push_back("b_h");
        names__.push_back("R");
        names__.push_back("D1_init");
        names__.push_back("H");
        names__.push_back("rr");
        names__.push_back("mu");
        names__.push_back("D");
        names__.push_back("D_p");
        names__.push_back("R_p");
        names__.push_back("R_forecasted");
        names__.push_back("H_p");
        names__.push_back("H_forecasted");
        names__.push_back("mu_p");
        names__.push_back("mu_forecasted");
        names__.push_back("rts_p");
        names__.push_back("rts_forecasted");
        names__.push_back("rr_p");
        names__.push_back("log_lik");
        names__.push_back("vd");
        names__.push_back("ma_d");
        names__.push_back("ar_d");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Q);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(P);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((T - 1));
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((ahead + std::max(Q, P)));
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((ahead + std::max(Q, P)));
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ahead);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((ahead + std::max(Q, P)));
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ahead);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((ahead + std::max(Q, P)));
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ahead);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((ahead + std::max(Q, P)));
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ahead);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((ahead + std::max(Q, P)));
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(compute_log_lik, 1) ? ahead : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_forecastCCC_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> phi0 = in__.vector_constrain(nt);
        size_t phi0_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < phi0_j_1_max__; ++j_1__) {
            vars__.push_back(phi0(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> phi = in__.matrix_lub_constrain(-(1), 1, nt, nt);
        size_t phi_j_2_max__ = nt;
        size_t phi_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < phi_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                vars__.push_back(phi(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> theta = in__.matrix_lub_constrain(-(1), 1, nt, nt);
        size_t theta_j_2_max__ = nt;
        size_t theta_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < theta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                vars__.push_back(theta(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta = in__.vector_constrain(nt);
        size_t beta_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            vars__.push_back(beta(j_1__));
        }
        double nu = in__.scalar_lb_constrain(2);
        vars__.push_back(nu);
        Eigen::Matrix<double, Eigen::Dynamic, 1> c_h = in__.vector_constrain(nt);
        size_t c_h_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < c_h_j_1_max__; ++j_1__) {
            vars__.push_back(c_h(j_1__));
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > a_h;
        size_t a_h_d_0_max__ = Q;
        a_h.reserve(a_h_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < a_h_d_0_max__; ++d_0__) {
            a_h.push_back(in__.vector_lub_constrain(0, 1, nt));
        }
        size_t a_h_j_1_max__ = nt;
        size_t a_h_k_0_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < a_h_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < a_h_k_0_max__; ++k_0__) {
                vars__.push_back(a_h[k_0__](j_1__));
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > b_h;
        size_t b_h_d_0_max__ = P;
        b_h.reserve(b_h_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < b_h_d_0_max__; ++d_0__) {
            b_h.push_back(in__.vector_lub_constrain(0, 1, nt));
        }
        size_t b_h_j_1_max__ = nt;
        size_t b_h_k_0_max__ = P;
        for (size_t j_1__ = 0; j_1__ < b_h_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < b_h_k_0_max__; ++k_0__) {
                vars__.push_back(b_h[k_0__](j_1__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> R = in__.corr_matrix_constrain(nt);
        size_t R_j_2_max__ = nt;
        size_t R_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < R_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < R_j_1_max__; ++j_1__) {
                vars__.push_back(R(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> D1_init = in__.vector_lb_constrain(0, nt);
        size_t D1_init_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < D1_init_j_1_max__; ++j_1__) {
            vars__.push_back(D1_init(j_1__));
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > H;
        size_t H_d_0_max__ = T;
        H.reserve(H_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < H_d_0_max__; ++d_0__) {
            H.push_back(in__.cov_matrix_constrain(nt));
        }
        size_t H_j_2_max__ = nt;
        size_t H_j_1_max__ = nt;
        size_t H_k_0_max__ = T;
        for (size_t j_2__ = 0; j_2__ < H_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < H_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < H_k_0_max__; ++k_0__) {
                    vars__.push_back(H[k_0__](j_1__, j_2__));
                }
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > rr;
        size_t rr_d_0_max__ = (T - 1);
        rr.reserve(rr_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < rr_d_0_max__; ++d_0__) {
            rr.push_back(in__.vector_constrain(nt));
        }
        size_t rr_j_1_max__ = nt;
        size_t rr_k_0_max__ = (T - 1);
        for (size_t j_1__ = 0; j_1__ < rr_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < rr_k_0_max__; ++k_0__) {
                vars__.push_back(rr[k_0__](j_1__));
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > mu;
        size_t mu_d_0_max__ = T;
        mu.reserve(mu_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < mu_d_0_max__; ++d_0__) {
            mu.push_back(in__.vector_constrain(nt));
        }
        size_t mu_j_1_max__ = nt;
        size_t mu_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
                vars__.push_back(mu[k_0__](j_1__));
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > D;
        size_t D_d_0_max__ = T;
        D.reserve(D_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < D_d_0_max__; ++d_0__) {
            D.push_back(in__.vector_constrain(nt));
        }
        size_t D_j_1_max__ = nt;
        size_t D_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < D_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < D_k_0_max__; ++k_0__) {
                vars__.push_back(D[k_0__](j_1__));
            }
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            if (!include_gqs__ && !include_tparams__) return;
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 76;
            validate_non_negative_index("D_p", "nt", nt);
            validate_non_negative_index("D_p", "(ahead + std::max(Q, P))", (ahead + std::max(Q, P)));
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > D_p((ahead + std::max(Q, P)), Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
            stan::math::initialize(D_p, DUMMY_VAR__);
            stan::math::fill(D_p, DUMMY_VAR__);
            current_statement_begin__ = 77;
            validate_non_negative_index("R_p", "nt", nt);
            validate_non_negative_index("R_p", "nt", nt);
            validate_non_negative_index("R_p", "(ahead + std::max(Q, P))", (ahead + std::max(Q, P)));
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > R_p((ahead + std::max(Q, P)), Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
            stan::math::initialize(R_p, DUMMY_VAR__);
            stan::math::fill(R_p, DUMMY_VAR__);
            stan::math::assign(R_p,rep_array(R, (ahead + std::max(Q, P))));
            current_statement_begin__ = 78;
            validate_non_negative_index("R_forecasted", "nt", nt);
            validate_non_negative_index("R_forecasted", "nt", nt);
            validate_non_negative_index("R_forecasted", "ahead", ahead);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > R_forecasted(ahead, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
            stan::math::initialize(R_forecasted, DUMMY_VAR__);
            stan::math::fill(R_forecasted, DUMMY_VAR__);
            stan::math::assign(R_forecasted,rep_array(R, ahead));
            current_statement_begin__ = 80;
            validate_non_negative_index("H_p", "nt", nt);
            validate_non_negative_index("H_p", "nt", nt);
            validate_non_negative_index("H_p", "(ahead + std::max(Q, P))", (ahead + std::max(Q, P)));
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > H_p((ahead + std::max(Q, P)), Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
            stan::math::initialize(H_p, DUMMY_VAR__);
            stan::math::fill(H_p, DUMMY_VAR__);
            current_statement_begin__ = 81;
            validate_non_negative_index("H_forecasted", "nt", nt);
            validate_non_negative_index("H_forecasted", "nt", nt);
            validate_non_negative_index("H_forecasted", "ahead", ahead);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > H_forecasted(ahead, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
            stan::math::initialize(H_forecasted, DUMMY_VAR__);
            stan::math::fill(H_forecasted, DUMMY_VAR__);
            current_statement_begin__ = 84;
            validate_non_negative_index("mu_p", "nt", nt);
            validate_non_negative_index("mu_p", "(ahead + std::max(Q, P))", (ahead + std::max(Q, P)));
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > mu_p((ahead + std::max(Q, P)), Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
            stan::math::initialize(mu_p, DUMMY_VAR__);
            stan::math::fill(mu_p, DUMMY_VAR__);
            current_statement_begin__ = 85;
            validate_non_negative_index("mu_forecasted", "nt", nt);
            validate_non_negative_index("mu_forecasted", "ahead", ahead);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > mu_forecasted(ahead, Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
            stan::math::initialize(mu_forecasted, DUMMY_VAR__);
            stan::math::fill(mu_forecasted, DUMMY_VAR__);
            current_statement_begin__ = 87;
            validate_non_negative_index("rts_p", "nt", nt);
            validate_non_negative_index("rts_p", "(ahead + std::max(Q, P))", (ahead + std::max(Q, P)));
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > rts_p((ahead + std::max(Q, P)), Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
            stan::math::initialize(rts_p, DUMMY_VAR__);
            stan::math::fill(rts_p, DUMMY_VAR__);
            current_statement_begin__ = 88;
            validate_non_negative_index("rts_forecasted", "nt", nt);
            validate_non_negative_index("rts_forecasted", "ahead", ahead);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > rts_forecasted(ahead, Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
            stan::math::initialize(rts_forecasted, DUMMY_VAR__);
            stan::math::fill(rts_forecasted, DUMMY_VAR__);
            current_statement_begin__ = 89;
            validate_non_negative_index("rr_p", "nt", nt);
            validate_non_negative_index("rr_p", "(ahead + std::max(Q, P))", (ahead + std::max(Q, P)));
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > rr_p((ahead + std::max(Q, P)), Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
            stan::math::initialize(rr_p, DUMMY_VAR__);
            stan::math::fill(rr_p, DUMMY_VAR__);
            current_statement_begin__ = 93;
            validate_non_negative_index("log_lik", "(logical_eq(compute_log_lik, 1) ? ahead : 0 )", (logical_eq(compute_log_lik, 1) ? ahead : 0 ));
            std::vector<double> log_lik((logical_eq(compute_log_lik, 1) ? ahead : 0 ), double(0));
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            current_statement_begin__ = 95;
            validate_non_negative_index("vd", "nt", nt);
            std::vector<double> vd(nt, double(0));
            stan::math::initialize(vd, DUMMY_VAR__);
            stan::math::fill(vd, DUMMY_VAR__);
            current_statement_begin__ = 96;
            validate_non_negative_index("ma_d", "nt", nt);
            std::vector<double> ma_d(nt, double(0));
            stan::math::initialize(ma_d, DUMMY_VAR__);
            stan::math::fill(ma_d, DUMMY_VAR__);
            current_statement_begin__ = 97;
            validate_non_negative_index("ar_d", "nt", nt);
            std::vector<double> ar_d(nt, double(0));
            stan::math::initialize(ar_d, DUMMY_VAR__);
            stan::math::fill(ar_d, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 100;
            stan::model::assign(mu_p, 
                        stan::model::cons_list(stan::model::index_min_max(1, (ahead + std::max(Q, P))), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_min_max(1, (ahead + std::max(Q, P))), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu"), 
                        "assigning variable mu_p");
            current_statement_begin__ = 101;
            stan::model::assign(rts_p, 
                        stan::model::cons_list(stan::model::index_min_max(1, (ahead + std::max(Q, P))), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_min_max(1, (ahead + std::max(Q, P))), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts"), 
                        "assigning variable rts_p");
            current_statement_begin__ = 102;
            stan::model::assign(rr_p, 
                        stan::model::cons_list(stan::model::index_min_max(1, (ahead + std::max(Q, P))), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        stan::model::rvalue(rr, stan::model::cons_list(stan::model::index_min_max(1, (ahead + std::max(Q, P))), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rr"), 
                        "assigning variable rr_p");
            current_statement_begin__ = 103;
            stan::model::assign(D_p, 
                        stan::model::cons_list(stan::model::index_min_max(1, (ahead + std::max(Q, P))), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        stan::model::rvalue(D, stan::model::cons_list(stan::model::index_min_max(1, (ahead + std::max(Q, P))), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "D"), 
                        "assigning variable D_p");
            current_statement_begin__ = 104;
            stan::model::assign(H_p, 
                        stan::model::cons_list(stan::model::index_min_max(1, (ahead + std::max(Q, P))), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        stan::model::rvalue(H, stan::model::cons_list(stan::model::index_min_max(1, (ahead + std::max(Q, P))), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "H"), 
                        "assigning variable H_p");
            current_statement_begin__ = 107;
            stan::model::assign(mu_p, 
                        stan::model::cons_list(stan::model::index_min_max(1, std::max(Q, P)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_min_max((T - (std::max(Q, P) - 1)), T), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu"), 
                        "assigning variable mu_p");
            current_statement_begin__ = 108;
            stan::model::assign(rts_p, 
                        stan::model::cons_list(stan::model::index_min_max(1, std::max(Q, P)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_min_max((T - (std::max(Q, P) - 1)), T), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts"), 
                        "assigning variable rts_p");
            current_statement_begin__ = 110;
            stan::model::assign(rr_p, 
                        stan::model::cons_list(stan::model::index_min_max(1, std::max(Q, P)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        stan::model::rvalue(rr, stan::model::cons_list(stan::model::index_min_max(((T - 1) - (std::max(Q, P) - 1)), (T - 1)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rr"), 
                        "assigning variable rr_p");
            current_statement_begin__ = 111;
            stan::model::assign(D_p, 
                        stan::model::cons_list(stan::model::index_min_max(1, std::max(Q, P)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        stan::model::rvalue(D, stan::model::cons_list(stan::model::index_min_max((T - (std::max(Q, P) - 1)), T), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "D"), 
                        "assigning variable D_p");
            current_statement_begin__ = 112;
            stan::model::assign(H_p, 
                        stan::model::cons_list(stan::model::index_min_max(1, std::max(Q, P)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        stan::model::rvalue(H, stan::model::cons_list(stan::model::index_min_max((T - (std::max(Q, P) - 1)), T), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "H"), 
                        "assigning variable H_p");
            current_statement_begin__ = 117;
            for (int t = (std::max(Q, P) + 1); t <= (std::max(Q, P) + ahead); ++t) {
                current_statement_begin__ = 119;
                if (as_bool(logical_eq(meanstructure, 0))) {
                    current_statement_begin__ = 120;
                    stan::model::assign(mu_p, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                phi0, 
                                "assigning variable mu_p");
                } else if (as_bool(logical_eq(meanstructure, 1))) {
                    current_statement_begin__ = 122;
                    stan::model::assign(mu_p, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                stan::model::deep_copy(add(add(phi0, multiply(phi, stan::model::rvalue(rts_p, stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts_p"))), multiply(theta, subtract(stan::model::rvalue(rts_p, stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts_p"), stan::model::rvalue(mu_p, stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu_p"))))), 
                                "assigning variable mu_p");
                }
                current_statement_begin__ = 126;
                for (int d = 1; d <= nt; ++d) {
                    current_statement_begin__ = 127;
                    stan::model::assign(vd, 
                                stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list()), 
                                0.0, 
                                "assigning variable vd");
                    current_statement_begin__ = 128;
                    stan::model::assign(ma_d, 
                                stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list()), 
                                0.0, 
                                "assigning variable ma_d");
                    current_statement_begin__ = 129;
                    stan::model::assign(ar_d, 
                                stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list()), 
                                0.0, 
                                "assigning variable ar_d");
                    current_statement_begin__ = 131;
                    for (int q = 1; q <= std::min((t - 1), Q); ++q) {
                        current_statement_begin__ = 132;
                        stan::model::assign(rr_p, 
                                    stan::model::cons_list(stan::model::index_uni((t - q)), stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list())), 
                                    square((get_base1(get_base1(rts_p, (t - q), "rts_p", 1), d, "rts_p", 2) - get_base1(get_base1(mu_p, (t - q), "mu_p", 1), d, "mu_p", 2))), 
                                    "assigning variable rr_p");
                        current_statement_begin__ = 133;
                        stan::model::assign(ma_d, 
                                    stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list()), 
                                    (get_base1(ma_d, d, "ma_d", 1) + (get_base1(get_base1(a_h, q, "a_h", 1), d, "a_h", 2) * get_base1(get_base1(rr_p, (t - q), "rr_p", 1), d, "rr_p", 2))), 
                                    "assigning variable ma_d");
                    }
                    current_statement_begin__ = 135;
                    for (int p = 1; p <= std::min((t - 1), P); ++p) {
                        current_statement_begin__ = 136;
                        stan::model::assign(ar_d, 
                                    stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list()), 
                                    (get_base1(ar_d, d, "ar_d", 1) + (get_base1(get_base1(b_h, p, "b_h", 1), d, "b_h", 2) * pow(get_base1(get_base1(D_p, (t - p), "D_p", 1), d, "D_p", 2), 2))), 
                                    "assigning variable ar_d");
                    }
                    current_statement_begin__ = 138;
                    if (as_bool(logical_gte(xC_marker, 1))) {
                        current_statement_begin__ = 139;
                        stan::model::assign(vd, 
                                    stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list()), 
                                    ((stan::math::exp((get_base1(c_h, d, "c_h", 1) + (get_base1(beta, d, "beta", 1) * get_base1(xC_c, t, d, "xC_c", 1)))) + get_base1(ma_d, d, "ma_d", 1)) + get_base1(ar_d, d, "ar_d", 1)), 
                                    "assigning variable vd");
                    } else if (as_bool(logical_eq(xC_marker, 0))) {
                        current_statement_begin__ = 141;
                        stan::model::assign(vd, 
                                    stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list()), 
                                    ((stan::math::exp(get_base1(c_h, d, "c_h", 1)) + get_base1(ma_d, d, "ma_d", 1)) + get_base1(ar_d, d, "ar_d", 1)), 
                                    "assigning variable vd");
                    }
                    current_statement_begin__ = 143;
                    stan::model::assign(D_p, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list())), 
                                stan::math::sqrt(get_base1(vd, d, "vd", 1)), 
                                "assigning variable D_p");
                }
                current_statement_begin__ = 145;
                stan::model::assign(H_p, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                            quad_form_diag(R, stan::model::rvalue(D_p, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "D_p")), 
                            "assigning variable H_p");
                current_statement_begin__ = 148;
                if (as_bool(logical_eq(distribution, 0))) {
                    current_statement_begin__ = 149;
                    stan::model::assign(rts_p, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                multi_normal_rng(stan::model::rvalue(mu_p, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu_p"), stan::model::rvalue(H_p, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "H_p"), base_rng__), 
                                "assigning variable rts_p");
                } else if (as_bool(logical_eq(distribution, 1))) {
                    current_statement_begin__ = 151;
                    stan::model::assign(rts_p, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                multi_student_t_rng(nu, stan::model::rvalue(mu_p, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu_p"), stan::model::rvalue(H_p, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "H_p"), base_rng__), 
                                "assigning variable rts_p");
                }
            }
            current_statement_begin__ = 169;
            stan::math::assign(rts_forecasted, stan::model::rvalue(rts_p, stan::model::cons_list(stan::model::index_min_max((std::max(Q, P) + 1), (std::max(Q, P) + ahead)), stan::model::nil_index_list()), "rts_p"));
            current_statement_begin__ = 170;
            stan::math::assign(H_forecasted, stan::model::rvalue(H_p, stan::model::cons_list(stan::model::index_min_max((std::max(Q, P) + 1), (std::max(Q, P) + ahead)), stan::model::nil_index_list()), "H_p"));
            current_statement_begin__ = 172;
            stan::math::assign(mu_forecasted, stan::model::rvalue(mu_p, stan::model::cons_list(stan::model::index_min_max((std::max(Q, P) + 1), (std::max(Q, P) + ahead)), stan::model::nil_index_list()), "mu_p"));
            current_statement_begin__ = 173;
            if (as_bool(compute_log_lik)) {
                current_statement_begin__ = 174;
                if (as_bool(logical_eq(distribution, 0))) {
                    current_statement_begin__ = 175;
                    for (int i = 1; i <= ahead; ++i) {
                        current_statement_begin__ = 176;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    multi_normal_log(get_base1(future_rts, i, "future_rts", 1), get_base1(mu_forecasted, i, "mu_forecasted", 1), get_base1(H_forecasted, i, "H_forecasted", 1)), 
                                    "assigning variable log_lik");
                    }
                } else if (as_bool(logical_eq(distribution, 1))) {
                    current_statement_begin__ = 179;
                    for (int i = 1; i <= ahead; ++i) {
                        current_statement_begin__ = 180;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    multi_student_t_log(get_base1(future_rts, i, "future_rts", 1), nu, get_base1(mu_forecasted, i, "mu_forecasted", 1), get_base1(H_forecasted, i, "H_forecasted", 1)), 
                                    "assigning variable log_lik");
                    }
                }
            }
            // validate, write generated quantities
            current_statement_begin__ = 76;
            size_t D_p_j_1_max__ = nt;
            size_t D_p_k_0_max__ = (ahead + std::max(Q, P));
            for (size_t j_1__ = 0; j_1__ < D_p_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < D_p_k_0_max__; ++k_0__) {
                    vars__.push_back(D_p[k_0__](j_1__));
                }
            }
            current_statement_begin__ = 77;
            size_t R_p_i_0_max__ = (ahead + std::max(Q, P));
            for (size_t i_0__ = 0; i_0__ < R_p_i_0_max__; ++i_0__) {
                stan::math::check_corr_matrix(function__, "R_p[i_0__]", R_p[i_0__]);
            }
            size_t R_p_j_2_max__ = nt;
            size_t R_p_j_1_max__ = nt;
            size_t R_p_k_0_max__ = (ahead + std::max(Q, P));
            for (size_t j_2__ = 0; j_2__ < R_p_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < R_p_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < R_p_k_0_max__; ++k_0__) {
                        vars__.push_back(R_p[k_0__](j_1__, j_2__));
                    }
                }
            }
            current_statement_begin__ = 78;
            size_t R_forecasted_i_0_max__ = ahead;
            for (size_t i_0__ = 0; i_0__ < R_forecasted_i_0_max__; ++i_0__) {
                stan::math::check_corr_matrix(function__, "R_forecasted[i_0__]", R_forecasted[i_0__]);
            }
            size_t R_forecasted_j_2_max__ = nt;
            size_t R_forecasted_j_1_max__ = nt;
            size_t R_forecasted_k_0_max__ = ahead;
            for (size_t j_2__ = 0; j_2__ < R_forecasted_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < R_forecasted_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < R_forecasted_k_0_max__; ++k_0__) {
                        vars__.push_back(R_forecasted[k_0__](j_1__, j_2__));
                    }
                }
            }
            current_statement_begin__ = 80;
            size_t H_p_i_0_max__ = (ahead + std::max(Q, P));
            for (size_t i_0__ = 0; i_0__ < H_p_i_0_max__; ++i_0__) {
                stan::math::check_cov_matrix(function__, "H_p[i_0__]", H_p[i_0__]);
            }
            size_t H_p_j_2_max__ = nt;
            size_t H_p_j_1_max__ = nt;
            size_t H_p_k_0_max__ = (ahead + std::max(Q, P));
            for (size_t j_2__ = 0; j_2__ < H_p_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < H_p_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < H_p_k_0_max__; ++k_0__) {
                        vars__.push_back(H_p[k_0__](j_1__, j_2__));
                    }
                }
            }
            current_statement_begin__ = 81;
            size_t H_forecasted_i_0_max__ = ahead;
            for (size_t i_0__ = 0; i_0__ < H_forecasted_i_0_max__; ++i_0__) {
                stan::math::check_cov_matrix(function__, "H_forecasted[i_0__]", H_forecasted[i_0__]);
            }
            size_t H_forecasted_j_2_max__ = nt;
            size_t H_forecasted_j_1_max__ = nt;
            size_t H_forecasted_k_0_max__ = ahead;
            for (size_t j_2__ = 0; j_2__ < H_forecasted_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < H_forecasted_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < H_forecasted_k_0_max__; ++k_0__) {
                        vars__.push_back(H_forecasted[k_0__](j_1__, j_2__));
                    }
                }
            }
            current_statement_begin__ = 84;
            size_t mu_p_j_1_max__ = nt;
            size_t mu_p_k_0_max__ = (ahead + std::max(Q, P));
            for (size_t j_1__ = 0; j_1__ < mu_p_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < mu_p_k_0_max__; ++k_0__) {
                    vars__.push_back(mu_p[k_0__](j_1__));
                }
            }
            current_statement_begin__ = 85;
            size_t mu_forecasted_j_1_max__ = nt;
            size_t mu_forecasted_k_0_max__ = ahead;
            for (size_t j_1__ = 0; j_1__ < mu_forecasted_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < mu_forecasted_k_0_max__; ++k_0__) {
                    vars__.push_back(mu_forecasted[k_0__](j_1__));
                }
            }
            current_statement_begin__ = 87;
            size_t rts_p_j_1_max__ = nt;
            size_t rts_p_k_0_max__ = (ahead + std::max(Q, P));
            for (size_t j_1__ = 0; j_1__ < rts_p_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < rts_p_k_0_max__; ++k_0__) {
                    vars__.push_back(rts_p[k_0__](j_1__));
                }
            }
            current_statement_begin__ = 88;
            size_t rts_forecasted_j_1_max__ = nt;
            size_t rts_forecasted_k_0_max__ = ahead;
            for (size_t j_1__ = 0; j_1__ < rts_forecasted_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < rts_forecasted_k_0_max__; ++k_0__) {
                    vars__.push_back(rts_forecasted[k_0__](j_1__));
                }
            }
            current_statement_begin__ = 89;
            size_t rr_p_j_1_max__ = nt;
            size_t rr_p_k_0_max__ = (ahead + std::max(Q, P));
            for (size_t j_1__ = 0; j_1__ < rr_p_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < rr_p_k_0_max__; ++k_0__) {
                    vars__.push_back(rr_p[k_0__](j_1__));
                }
            }
            current_statement_begin__ = 93;
            size_t log_lik_k_0_max__ = (logical_eq(compute_log_lik, 1) ? ahead : 0 );
            for (size_t k_0__ = 0; k_0__ < log_lik_k_0_max__; ++k_0__) {
                vars__.push_back(log_lik[k_0__]);
            }
            current_statement_begin__ = 95;
            size_t vd_i_0_max__ = nt;
            for (size_t i_0__ = 0; i_0__ < vd_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "vd[i_0__]", vd[i_0__], 0);
            }
            size_t vd_k_0_max__ = nt;
            for (size_t k_0__ = 0; k_0__ < vd_k_0_max__; ++k_0__) {
                vars__.push_back(vd[k_0__]);
            }
            current_statement_begin__ = 96;
            size_t ma_d_i_0_max__ = nt;
            for (size_t i_0__ = 0; i_0__ < ma_d_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "ma_d[i_0__]", ma_d[i_0__], 0);
            }
            size_t ma_d_k_0_max__ = nt;
            for (size_t k_0__ = 0; k_0__ < ma_d_k_0_max__; ++k_0__) {
                vars__.push_back(ma_d[k_0__]);
            }
            current_statement_begin__ = 97;
            size_t ar_d_i_0_max__ = nt;
            for (size_t i_0__ = 0; i_0__ < ar_d_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "ar_d[i_0__]", ar_d[i_0__], 0);
            }
            size_t ar_d_k_0_max__ = nt;
            for (size_t k_0__ = 0; k_0__ < ar_d_k_0_max__; ++k_0__) {
                vars__.push_back(ar_d[k_0__]);
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_forecastCCC";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t phi0_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < phi0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t phi_j_2_max__ = nt;
        size_t phi_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < phi_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "phi" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t theta_j_2_max__ = nt;
        size_t theta_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < theta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t beta_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "nu";
        param_names__.push_back(param_name_stream__.str());
        size_t c_h_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < c_h_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "c_h" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t a_h_j_1_max__ = nt;
        size_t a_h_k_0_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < a_h_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < a_h_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "a_h" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t b_h_j_1_max__ = nt;
        size_t b_h_k_0_max__ = P;
        for (size_t j_1__ = 0; j_1__ < b_h_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < b_h_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b_h" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t R_j_2_max__ = nt;
        size_t R_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < R_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < R_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "R" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t D1_init_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < D1_init_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "D1_init" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t H_j_2_max__ = nt;
        size_t H_j_1_max__ = nt;
        size_t H_k_0_max__ = T;
        for (size_t j_2__ = 0; j_2__ < H_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < H_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < H_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "H" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t rr_j_1_max__ = nt;
        size_t rr_k_0_max__ = (T - 1);
        for (size_t j_1__ = 0; j_1__ < rr_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < rr_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rr" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t mu_j_1_max__ = nt;
        size_t mu_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t D_j_1_max__ = nt;
        size_t D_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < D_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < D_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "D" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
        size_t D_p_j_1_max__ = nt;
        size_t D_p_k_0_max__ = (ahead + std::max(Q, P));
        for (size_t j_1__ = 0; j_1__ < D_p_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < D_p_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "D_p" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t R_p_j_2_max__ = nt;
        size_t R_p_j_1_max__ = nt;
        size_t R_p_k_0_max__ = (ahead + std::max(Q, P));
        for (size_t j_2__ = 0; j_2__ < R_p_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < R_p_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < R_p_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "R_p" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t R_forecasted_j_2_max__ = nt;
        size_t R_forecasted_j_1_max__ = nt;
        size_t R_forecasted_k_0_max__ = ahead;
        for (size_t j_2__ = 0; j_2__ < R_forecasted_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < R_forecasted_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < R_forecasted_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "R_forecasted" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t H_p_j_2_max__ = nt;
        size_t H_p_j_1_max__ = nt;
        size_t H_p_k_0_max__ = (ahead + std::max(Q, P));
        for (size_t j_2__ = 0; j_2__ < H_p_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < H_p_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < H_p_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "H_p" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t H_forecasted_j_2_max__ = nt;
        size_t H_forecasted_j_1_max__ = nt;
        size_t H_forecasted_k_0_max__ = ahead;
        for (size_t j_2__ = 0; j_2__ < H_forecasted_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < H_forecasted_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < H_forecasted_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "H_forecasted" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t mu_p_j_1_max__ = nt;
        size_t mu_p_k_0_max__ = (ahead + std::max(Q, P));
        for (size_t j_1__ = 0; j_1__ < mu_p_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < mu_p_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu_p" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t mu_forecasted_j_1_max__ = nt;
        size_t mu_forecasted_k_0_max__ = ahead;
        for (size_t j_1__ = 0; j_1__ < mu_forecasted_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < mu_forecasted_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu_forecasted" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t rts_p_j_1_max__ = nt;
        size_t rts_p_k_0_max__ = (ahead + std::max(Q, P));
        for (size_t j_1__ = 0; j_1__ < rts_p_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < rts_p_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rts_p" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t rts_forecasted_j_1_max__ = nt;
        size_t rts_forecasted_k_0_max__ = ahead;
        for (size_t j_1__ = 0; j_1__ < rts_forecasted_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < rts_forecasted_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rts_forecasted" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t rr_p_j_1_max__ = nt;
        size_t rr_p_k_0_max__ = (ahead + std::max(Q, P));
        for (size_t j_1__ = 0; j_1__ < rr_p_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < rr_p_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rr_p" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t log_lik_k_0_max__ = (logical_eq(compute_log_lik, 1) ? ahead : 0 );
        for (size_t k_0__ = 0; k_0__ < log_lik_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t vd_k_0_max__ = nt;
        for (size_t k_0__ = 0; k_0__ < vd_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vd" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ma_d_k_0_max__ = nt;
        for (size_t k_0__ = 0; k_0__ < ma_d_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ma_d" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ar_d_k_0_max__ = nt;
        for (size_t k_0__ = 0; k_0__ < ar_d_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ar_d" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t phi0_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < phi0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t phi_j_2_max__ = nt;
        size_t phi_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < phi_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "phi" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t theta_j_2_max__ = nt;
        size_t theta_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < theta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t beta_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "nu";
        param_names__.push_back(param_name_stream__.str());
        size_t c_h_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < c_h_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "c_h" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t a_h_j_1_max__ = nt;
        size_t a_h_k_0_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < a_h_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < a_h_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "a_h" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t b_h_j_1_max__ = nt;
        size_t b_h_k_0_max__ = P;
        for (size_t j_1__ = 0; j_1__ < b_h_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < b_h_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b_h" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t R_j_1_max__ = ((nt * (nt - 1)) / 2);
        for (size_t j_1__ = 0; j_1__ < R_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "R" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t D1_init_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < D1_init_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "D1_init" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t H_j_1_max__ = (nt + ((nt * (nt - 1)) / 2));
        size_t H_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < H_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < H_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "H" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t rr_j_1_max__ = nt;
        size_t rr_k_0_max__ = (T - 1);
        for (size_t j_1__ = 0; j_1__ < rr_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < rr_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rr" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t mu_j_1_max__ = nt;
        size_t mu_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t D_j_1_max__ = nt;
        size_t D_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < D_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < D_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "D" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
        size_t D_p_j_1_max__ = nt;
        size_t D_p_k_0_max__ = (ahead + std::max(Q, P));
        for (size_t j_1__ = 0; j_1__ < D_p_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < D_p_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "D_p" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t R_p_j_1_max__ = ((nt * (nt - 1)) / 2);
        size_t R_p_k_0_max__ = (ahead + std::max(Q, P));
        for (size_t j_1__ = 0; j_1__ < R_p_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < R_p_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "R_p" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t R_forecasted_j_1_max__ = ((nt * (nt - 1)) / 2);
        size_t R_forecasted_k_0_max__ = ahead;
        for (size_t j_1__ = 0; j_1__ < R_forecasted_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < R_forecasted_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "R_forecasted" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t H_p_j_1_max__ = (nt + ((nt * (nt - 1)) / 2));
        size_t H_p_k_0_max__ = (ahead + std::max(Q, P));
        for (size_t j_1__ = 0; j_1__ < H_p_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < H_p_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "H_p" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t H_forecasted_j_1_max__ = (nt + ((nt * (nt - 1)) / 2));
        size_t H_forecasted_k_0_max__ = ahead;
        for (size_t j_1__ = 0; j_1__ < H_forecasted_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < H_forecasted_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "H_forecasted" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t mu_p_j_1_max__ = nt;
        size_t mu_p_k_0_max__ = (ahead + std::max(Q, P));
        for (size_t j_1__ = 0; j_1__ < mu_p_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < mu_p_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu_p" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t mu_forecasted_j_1_max__ = nt;
        size_t mu_forecasted_k_0_max__ = ahead;
        for (size_t j_1__ = 0; j_1__ < mu_forecasted_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < mu_forecasted_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu_forecasted" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t rts_p_j_1_max__ = nt;
        size_t rts_p_k_0_max__ = (ahead + std::max(Q, P));
        for (size_t j_1__ = 0; j_1__ < rts_p_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < rts_p_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rts_p" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t rts_forecasted_j_1_max__ = nt;
        size_t rts_forecasted_k_0_max__ = ahead;
        for (size_t j_1__ = 0; j_1__ < rts_forecasted_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < rts_forecasted_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rts_forecasted" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t rr_p_j_1_max__ = nt;
        size_t rr_p_k_0_max__ = (ahead + std::max(Q, P));
        for (size_t j_1__ = 0; j_1__ < rr_p_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < rr_p_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rr_p" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t log_lik_k_0_max__ = (logical_eq(compute_log_lik, 1) ? ahead : 0 );
        for (size_t k_0__ = 0; k_0__ < log_lik_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t vd_k_0_max__ = nt;
        for (size_t k_0__ = 0; k_0__ < vd_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vd" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ma_d_k_0_max__ = nt;
        for (size_t k_0__ = 0; k_0__ < ma_d_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ma_d" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ar_d_k_0_max__ = nt;
        for (size_t k_0__ = 0; k_0__ < ar_d_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ar_d" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_forecastCCC_namespace::model_forecastCCC stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
