% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{hugo_installers}
\alias{hugo_installers}
\title{Available Hugo installers of a version}
\usage{
hugo_installers(version = "latest")
}
\arguments{
\item{version}{A version number. The default is to automatically detect the
latest version. Versions before v0.17 are not supported.}
}
\value{
A data frame containing columns \code{os} (operating system),
  \code{arch} (architecture), and \code{extended} (extended version or not).
  If your R version is lower than 4.1.0, a character vector of the installer
  filenames will be returned instead.
}
\description{
Given a version number, return the information of available installers. If
\code{\link{install_hugo}()} fails, you may run this function to check the
available installers and obtain their \code{os}/\code{arch} info.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
blogdown::hugo_installers()
blogdown::hugo_installers("0.89.0")
blogdown::hugo_installers("0.7")
\dontshow{\}) # examplesIf}
}
