% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hugo.R
\name{install_theme}
\alias{install_theme}
\title{Install a Hugo theme from Github}
\usage{
install_theme(theme, theme_example = FALSE, update_config = TRUE, force = FALSE)
}
\arguments{
\item{theme}{A Hugo theme on Github (a chararacter string of the form
\code{user/repo}, and you can optionally sepecify a GIT branch or tag name
after \code{@}, i.e. \code{theme} can be of the form
\code{user/repo@branch}). If \code{theme = NA}, no themes will be
installed, and you have to manually install a theme.}

\item{theme_example}{Whether to copy the example in the \file{exampleSite}
directory if it exists in the theme. Not all themes provide example sites.}

\item{update_config}{Whether to update the \code{theme} option in the site
configurations.}

\item{force}{Whether to override the existing theme of the same name. If you
have made changes to this existing theme, your changes will be lost when
\code{force = TRUE}! Please consider backing up the theme by renaming it
before you try \code{force = TRUE}.}
}
\description{
Download the specified theme from Github and install to the \file{themes}
directory. Available themes are listed at \url{http://themes.gohugo.io}.
}
