% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCocluster.R
\name{blockcluster}
\alias{blockcluster}
\title{Co-Clustering Package}
\description{
This package performs Co-clustering of binary, contingency, continuous and
categorical data-sets.
}
\details{
This package performs Co-clustering of binary, contingency, continuous and
categorical data-sets with utility functions to visualize the Co-clustered
data. The package contains a set of functions \code{\link{coclusterBinary}},
\code{\link{coclusterCategorical}}, \code{\link{coclusterContingency}},
\code{\link{coclusterContinuous}} which perform Co-clustering on various
kinds of data-sets and return object of appropriate class (refer to
documentation of these functions. The package also contains function
\code{\link{coclusterStrategy}} (see documentation of function to know
various slots) which returns an object of class \code{\linkS4class{strategy}}.
This object can be given as input to co-clustering functions to control
various Co-clustering parameters. Please refer to testmodels.R file which is
included in "test" directory to see examples with various models and
simulated data-sets.

The package also provide utility functions like summary() and plot() to
summarize results and plot the original and Co-clustered data respectively.
}
\examples{

## Simple example with simulated binary data
## load data
data(binarydata)
## usage of coclusterBinary function in its most simplest form
out<-coclusterBinary(binarydata,nbcocluster=c(2,3))
#" Summarize the output results
summary(out)
## Plot the original and Co-clustered data 
plot(out)

}
