% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blkboxSplit.R
\name{Partition}
\alias{Partition}
\title{blkbox paritioning}
\usage{
Partition(data, labels, size, seed)
}
\arguments{
\item{data}{A data.frame of the data. Rows represent samples and columns features.}

\item{labels}{The labels corresponding to the data, order must match with order of rows in data.}

\item{size}{determines the size of the holdout data, must be a numeric value between 0 and 1 that. Default is 0.8.}

\item{seed}{Determines the seed used to randomly sample the data by row.}
}
\description{
Prepares data for standard training and testing, data will be split into training and holdout set and output in a list which can be directly supplied to blkbox.
}
\examples{
\donttest{
# Partitioning Data
my_partition = Partition(data = my_data,
                         labels = my_labels)
# Creating a Training & Testing Model
model_1 <- blkbox(data = my_partition)
}
}
\author{
Zachary Davies, Boris Guennewig
}
\keyword{blkbox,}
\keyword{partition}

