% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blinfit.R
\name{blin_mle}
\alias{blin_mle}
\title{Estimate the BLIN model using maximum likelihood estimator}
\usage{
blin_mle(Y, X = NULL, type = "full", lag = 1, rankA = NULL,
  rankB = rankA, maxit = 1000, tol = 1e-08, init = "I",
  sigma_init = 1, verbose = FALSE, calcses = FALSE, randseed = NA)
}
\arguments{
\item{Y}{Response 3-mode array.}

\item{X}{Optional 4-mode array of covariates, defaults to no covariates.}

\item{type}{Optional string specifying BLIN model type: full, reduced_rank, or sparse. Defaults to full.}

\item{lag}{Optional numeric specifying autoregressive lag in model, defaults to 1.}

\item{rankA}{Optional numeric rank of influence network matrix \eqn{A} for reduced rank model type, defaults to full rank.}

\item{rankB}{Optional numeric rank of influence network matrix \eqn{B}, defaults to rank of \eqn{A}.}

\item{maxit}{Optional numeric maximum number of iterations for full and reduced rank block coordinate descents, defaults to 1e3.}

\item{tol}{Optional numeric convergence tolerance for full and reduced rank block coordinate descents, defaults to 1e-8.}

\item{init}{Optional string specifying initialization type for full and reduced rank block coordinate descents, defaults to "I", identity for \eqn{A} and \eqn{B}. Also allows "random" for random initialization of \eqn{A} and \eqn{B}.}

\item{sigma_init}{Optional numeric standard deviation for random initialization of \eqn{A} and \eqn{B} in  full and reduced rank block coordinate descents, defaults to 1.}

\item{verbose}{Optional logical specifying whether progress should be printed out (\code{TRUE}) or not (\code{FALSE}). Defaults to \code{FALSE}.}

\item{calcses}{Optional logical specifying whether standard errors should be calculated (\code{TRUE}) or not (\code{FALSE}). Defaults to \code{FALSE}. Only standard errors for the full BLIN model are implemented.}

\item{randseed}{Optional numeric specifying seed for random ininitialization of \eqn{A} and \eqn{B} in full and reduced rank block coordinate descents, defaults to \code{NA} (no seed set).}
}
\value{
\item{fit}{A \code{blin} object containing summary information.}
}
\description{
This function estimates the bipartite logitudinal influence network (BLIN) model \eqn{Y_t = A^T \sum_{k=1}^{lag} Y_{t-k} + \sum_{k=1}^{lag} Y_{t-k} B + X_t \beta + \tau E_t} using maximum likelihood estimator.
}
\details{
This function estimates the continuous BLIN model,
 \deqn{Y_t = A^T Y_{t-1} + Y_{t-1} B + X_t \beta + \tau E_t}, where \eqn{ \{ Y_t\}_t } is a set of \eqn{S \times L} matrices representing the bipartite relation data at each observation \eqn{t}. 
 The set \eqn{\{X_t \}_t} is a set of \eqn{S \times L \times p} arrays describing the influence of the
 coefficient vector \eqn{beta}. Finally, each matrix \eqn{E_t} is assumed to consist of iid standard normal random variables. The matrices \eqn{A} and \eqn{B} are square matrices respesenting the influence networks among \eqn{S} senders and \eqn{L} receivers, respectively. 
 
 This function estimates the BLIN model using maximum likelihood (and related) methods. The "full" model places no restrications on the influence networks \eqn{A} and \eqn{B}, and estimates
 these matrices (along with \eqn{\beta}) by block coordinate descent. In addition, if \code{calcses==TRUE}, the standard errors for each coefficient will be estimated. Note that the standard error procedure 
 may require large amounts of memory to build the BLIN design matrix; a warning is produced if the estimated size of the desgn is greater than 0.5GB. 
 
 The "reduced rank" BLIN model assumes that the matrix \eqn{A} has decomposition \eqn{A = UV^T}, where each of \eqn{U} and \eqn{V} is an \eqn{S \times \code{rankA}} matrix, and 
 the matrix \eqn{B} has decomposition \eqn{B = WZ^T}, where each of \eqn{W} and \eqn{Z} is an \eqn{L \times \code{rankB}} matrix. This model is also estimated using block coordinate descent. 
 
 Finally, the "sparse" BLIN model assumes that \eqn{A} and \eqn{B} matrices have many entries that are small or zero. The \code{cv.glmnet(.)} function from the \code{glmnet} package is used 
 to estimate the entries in \eqn{A}, \eqn{B}, and \eqn{beta}. The object resuling from \code{cv.glmnet(.)} is returned in this case. 
 
 Notice that the diagonals of \eqn{A} and \eqn{B} are not identifiable. However, the sum of each diagonal entry in \eqn{A} and \eqn{B}, i.e. \eqn{a_{ii} + b_{jj}}, is identifiable. Thus, 
 the diagonal sums are broken out as separate estimates under the name \code{diagAB}.
 
 If \code{calcses = TRUE} and \code{type = full}, then standard errors will be returned. These standard errors are based on the assumption that each \eqn{E_t} consists of iid standard normal random variables. 
 In this case, the full design matrix is built, which we call \eqn{W} here. Then, the variance-covariance matrix of the estimated coefficients is formed by \eqn{\hat{\tau}^2 (W^T W)^{-1}}, where \eqn{\hat{\tau}^2} is the usual unbiased estimator of the error variance.
}
\examples{
S <- 5
L <- 4
tmax <- 10
data <- generate_blin(S,L,tmax, lag=2, sparse=.8, seed=1)

fit <- blin_mle(data$Y, data$X, lag=2, calcses=TRUE)
summary(fit)

}
\seealso{
\code{\link{generate_blin}} \code{\link{build_design}}
}
\keyword{external}
