% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_cta_button.R
\name{add_cta_button}
\alias{add_cta_button}
\title{Helper function for adding a CTA button}
\usage{
add_cta_button(url, text, align = "left")
}
\arguments{
\item{url}{a URL for the button.}

\item{text}{the text that is placed atop
the CTA button.}

\item{align}{the alignment of the button
inside the main content area. Options are
\code{left} (the default), \code{right},
and \code{center}.}
}
\value{
a character object with an HTML
fragment that can be placed inside the
message body wherever the CTA button
should appear.
}
\description{
Add a call to action button
inside the body of the email with this
helper function. There are options to
specify the button text, the URL, and
the button's alignment.
}
\examples{
# Create the button as an HTML fragment
cta_button <-
  add_cta_button(
    url = "http://www.website.net",
    text = "Press This Button",
    align = "center")

# Include the button in the email
# message body by simply referencing
# the `cta_button` object
email <-
  compose_email(
    body = "
    Hello!

    Below is a call. It's a call \\\\
    to action. Press it!

    {cta_button}

    Cheers
    ")
}
