% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust.date.R
\name{adjust.date}
\alias{adjust.date}
\alias{adjust.next}
\alias{following}
\alias{adjust.none}
\alias{modified.following}
\alias{adjust.previous}
\alias{preceding}
\alias{modified.preceding}
\title{Adjusts the given dates to the next/previous business day}
\usage{
adjust.next(dates, cal)

following(dates, cal)

adjust.none(dates, cal)

modified.following(dates, cal)

adjust.previous(dates, cal)

preceding(dates, cal)

modified.preceding(dates, cal)
}
\arguments{
\item{dates}{dates to be adjusted}

\item{cal}{an instance of \code{Calendar}}
}
\value{
\code{Date} objects adjusted accordingly.
}
\description{
Rolls the given date to the next or previous business day,
unless it is a business day.
}
\details{
\code{adjust.next} and \code{following} return the next business day if the
given date
is not a business day.
\code{adjust.previous} and \code{preceding} are similar, but return the
previous
business day.
\code{modified.following} rolls the given date to the next business day,
unless
it happens in the next month, in this case it returns the previous business
day.
\code{modified.preceding} is similar to \code{modified.following}, but rolls
the given
date to the previous business day.
}
\section{Date types accepted}{


The argument \code{dates} accepts \code{Date} objects and any
object that returns a valid \code{Date} object when passed through
\code{as.Date}, which include all \code{POSIX*} classes and \code{character}
objects with ISO formatted dates.
}

\examples{
adjust.next("2013-01-01", "Brazil/ANBIMA")
following("2013-01-01", "Brazil/ANBIMA")
modified.following("2016-01-31", "Brazil/ANBIMA")
adjust.previous("2013-01-01", "Brazil/ANBIMA")
preceding("2013-01-01", "Brazil/ANBIMA")
modified.preceding("2016-01-01", "Brazil/ANBIMA")
}
