% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wtc_sig_parallel.R
\name{wtc_sig_parallel}
\alias{wtc_sig_parallel}
\title{Parallel \code{\link{wtc.sig}}}
\usage{
wtc_sig_parallel(nrands = 300, lag1, dt, ntimesteps, pad = TRUE,
  dj = 1/12, s0, J1, max.scale = NULL, mother = "morlet",
  sig.level = 0.95, quiet = TRUE)
}
\arguments{
\item{nrands}{Number of Monte Carlo randomizations.}

\item{lag1}{Vector containing the AR(1) coefficient of each time series.}

\item{dt}{Length of a time step.}

\item{ntimesteps}{Number of time steps in time series.}

\item{pad}{Pad the values will with zeros to increase the speed of the
transform.}

\item{dj}{Spacing between successive scales.}

\item{s0}{Smallest scale of the wavelet.}

\item{J1}{Number of scales - 1.}

\item{max.scale}{Maximum scale.}

\item{mother}{Type of mother wavelet function to use. Can be set to
\code{morlet}, \code{dog}, or \code{paul}.
Significance testing is only available for \code{morlet} wavelet.}

\item{sig.level}{Significance level to compute.}

\item{quiet}{Do not display progress bar.}
}
\description{
Parallelized Monte Carlo simulation equivalent to \code{\link{wtc.sig}}.
}
\examples{
# Not run: library(foreach)
# library(doParallel)
# cl <- makeCluster(4, outfile="") # number of cores. Notice 'outfile'
# registerDoParallel(cl)
# wtc_sig_parallel(your parameters go here)
# stopCluster(cl)

}
\seealso{
\code{\link[foreach]{foreach}}

\code{\link{wtc.sig}}
}
