% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convolve2D.R
\name{convolve2D}
\alias{convolve2D}
\title{Fast column-wise convolution of a matrix}
\usage{
convolve2D(x, y, conj = TRUE, type = c("circular", "open"))
}
\arguments{
\item{x}{M \code{x} n matrix.}

\item{y}{Numeric sequence of length N.}

\item{conj}{Logical; if \code{TRUE}, take the complex conjugate before
back-transforming. \code{TRUE} is used for usual convolution.}

\item{type}{Character; one of \code{circular}, \code{open} (beginning of word
  is ok).

  For \code{circular}, the two sequences are treated as circular, i.e.,
  periodic.

  For \code{open} and \code{filter}, the sequences are padded with zeros
  (from left and right) first; \code{filter} returns the middle sub-vector of
  open, namely, the result of running a weighted mean of \code{x} with
  weights \code{y}.}
}
\value{
M \code{x} n matrix
}
\description{
Use the Fast Fourier Transform to perform convolutions between a sequence and
each column of a matrix.
}
\details{
This is a corrupted version of convolve made by replacing
  \code{\link{fft}} with \code{\link{mvfft}} in a few places. It would be
  nice to submit this to the R Developers for inclusion.
}
\note{
This function was copied from \code{waveslim} to limit package
  dependencies.
}
\author{
Brandon Whitcher
}
