% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_pixel_picker.R
\name{bm_pixel_picker}
\alias{bm_pixel_picker}
\alias{bm_pixel_picker.bm_bitmap}
\alias{bm_pixel_picker.bm_pixmap}
\alias{bm_pixel_picker.raster}
\title{Bitmap pixel picker}
\usage{
bm_pixel_picker(x, ...)

\method{bm_pixel_picker}{bm_bitmap}(
  x,
  ...,
  col = getOption("bittermelon.col", col_bitmap),
  silent = FALSE
)

\method{bm_pixel_picker}{bm_pixmap}(x, ..., silent = FALSE)

\method{bm_pixel_picker}{raster}(x, ..., silent = FALSE)
}
\arguments{
\item{x}{Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_pixmap]{bm_pixmap()}},
or \link[grDevices:as.raster]{raster}  object}

\item{...}{Currently ignored.}

\item{col}{Character vector of R color specifications.
First color is used for values equal to 0, second color for values equal to 1, etc.}

\item{silent}{Don't generate messages about clicked pixels.}
}
\value{
A list with named components "row", "col", and "value"
for the last clicked pixel returned invisibly.
}
\description{
\code{bm_pixel_picker()} lets you use an interactive graphics device
to click on a bitmap's pixels and learn the
column/row coordinates for the clicked pixel and its integer/color value.
To end the program click a non-left mouse button within the graphics device.
}
\examples{
if (interactive() && dev.interactive(orNone = TRUE)) {
  corn <- farming_crops_16x16()$corn$portrait
  bm_pixel_picker(corn)
}
}
\seealso{
This function wraps \code{\link[grid:grid.locator]{grid::grid.locator()}}.
}
