% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_pixmap.R
\name{bm_pixmap}
\alias{bm_pixmap}
\title{Bittermelon pixmap matrix object}
\usage{
bm_pixmap(x)
}
\arguments{
\item{x}{Object to be converted to \code{bm_pixmap()}.
If not already a color string matrix it will be cast to one by \code{\link[=as_bm_pixmap]{as_bm_pixmap()}}.}
}
\value{
A character matrix of color strings with a \dQuote{bm_pixmap} subclass.
}
\description{
\code{bm_pixmap()} creates an S3 matrix subclass representing a pixmap.
}
\details{
\itemize{
\item Intended to represent raster graphic pixmaps especially (but not limited to) pixel art/sprites.
\item Pixmaps are represented as color string matrices with special class methods.
\item The bottom left pixel is represented by the first row and first column.
\item The bottom right pixel is represented by the first row and last column.
\item The top left pixel is represented by the last row and first column.
\item The top right pixel is represented by the last row and last column.
\item Colors are converted to the \code{"#RRGGBBAA"} color string format.
\item Fully transparent values like \code{"transparent"}, \code{NA}, \code{"#00000000"} are
all standardized to \code{"#FFFFFF00"}.
\item See \code{\link[=bm_bitmap]{bm_bitmap()}} for an alternative S3 object backed by a integer matrix.
}
}
\section{Supported S3 methods}{

\itemize{
\item \code{\link{[.bm_bitmap}} and \code{\link{[<-.bm_bitmap}}
\item \code{\link[=as.matrix.bm_pixmap]{as.matrix.bm_pixmap()}}
\item \code{\link[=as.raster.bm_bitmap]{as.raster.bm_bitmap()}} and \code{\link[=plot.bm_bitmap]{plot.bm_bitmap()}}
\item \code{\link[=format.bm_pixmap]{format.bm_pixmap()}} and \code{\link[=print.bm_pixmap]{print.bm_pixmap()}}
}
}

\examples{
# Bottom left pixel is **first** row and first column
pm <- bm_pixmap(matrix(c("red", "blue", "green", "black"),
                nrow = 2L, byrow = TRUE))
plot(pm)
}
\seealso{
\code{\link[=as_bm_pixmap]{as_bm_pixmap()}}, \code{\link[=is_bm_pixmap]{is_bm_pixmap()}}
}
