% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getManualVisibilityTable.R
\name{getManualVisibilityTable}
\alias{getManualVisibilityTable}
\title{Get manual visibility table}
\usage{
getManualVisibilityTable(dbConnection, dbDriverChar)
}
\arguments{
\item{dbConnection}{a valid  database connection}

\item{dbDriverChar}{the name of the driver. If different from 'PostgreSQL'
it connects to cloud.birdradar.com}
}
\value{
A dataframe with the manual visibility table
}
\description{
load visibility table from an already connected 'Birdscan MR1'
'SQL' database
}
\examples{
\dontrun{
# Set server and database settings
# ===========================================================================
  dbServer       = "MACHINE\\\\SERVERNAME"     # Set the name of your SQL server
  dbName         = "db_Name"                   # Set the name of your database
  dbDriverChar   = "SQL Server"                # Set either "SQL Server" or "PostgreSQL"

# Open the connection with the database
# ===========================================================================
  dsn = paste0("driver=", dbDriverChar, ";server=", dbServer,
               ";database=", dbName,
               ";uid=", rstudioapi::askForPassword("Database user"),
               ";pwd=", rstudioapi::askForPassword("Database password"))
  dbConnection = RODBC::odbcDriverConnect(dsn)

manualVisibilityTable = getManualVisibilityTable(dbConnection, dbDriverChar)
}

}
\author{
Baptiste Schmid \email{baptiste.schmid@vogelwarte.ch}; Birgen Haest
\email{birgen.haest@vogelwarte.ch}
}
