% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhclu_pam.R
\name{nhclu_pam}
\alias{nhclu_pam}
\title{Non hierarchical clustering: partitioning around medoids}
\usage{
nhclu_pam(
  dissimilarity,
  index = names(dissimilarity)[3],
  seed = NULL,
  n_clust = c(1, 2, 3),
  variant = "faster",
  nstart = 1,
  cluster_only = FALSE,
  algorithm_in_output = TRUE,
  ...
)
}
\arguments{
\item{dissimilarity}{the output object from \code{\link[=dissimilarity]{dissimilarity()}} or
\code{\link[=similarity_to_dissimilarity]{similarity_to_dissimilarity()}}, or a \code{dist} object. If a \code{data.frame} is
used, the first two columns represent pairs of sites (or any pair of nodes),
and the next column(s) are the dissimilarity indices.}

\item{index}{name or number of the dissimilarity column to use. By default,
the third column name of \code{dissimilarity} is used.}

\item{seed}{for the random number generator (NULL for random by default).}

\item{n_clust}{an \code{integer} or an \code{integer} vector specifying the
requested number(s) of clusters.}

\item{variant}{a \code{character} string specifying the variant of pam to use,
by default \code{faster}. Available options are \code{original}, \code{o_1}, \code{o_2}, \code{f_3},
\code{f_4}, \code{f_5} or \code{faster}. See \link[cluster:pam]{pam} for more details.}

\item{nstart}{an \code{integer} specifying the number of random start for the
pam algorithm. By default, 1 (for the \code{faster} variant).}

\item{cluster_only}{a \code{boolean} specifying if only the clustering should be
returned from the \link[cluster:pam]{pam} function (more efficient).}

\item{algorithm_in_output}{a \code{boolean} indicating if the original output
of \link[cluster:pam]{pam} should be returned in the output (\code{TRUE} by
default, see Value).}

\item{...}{you can add here further arguments to be passed to \code{pam()}
(see \link[cluster:pam]{pam})}
}
\value{
A \code{list} of class \code{bioregion.clusters} with five slots:
\enumerate{
\item{\strong{name}: \code{character} containing the name of the algorithm}
\item{\strong{args}: \code{list} of input arguments as provided by the user}
\item{\strong{inputs}: \code{list} of characteristics of the clustering process}
\item{\strong{algorithm}: \code{list} of all objects associated with the
clustering procedure, such as original cluster objects}
\item{\strong{clusters}: \code{data.frame} containing the clustering results}}

In the \code{algorithm} slot, if \code{algorithm_in_output = TRUE}, users can
find the output of
\link[cluster:pam]{pam}.
}
\description{
This function performs non hierarchical clustering on the basis of
dissimilarity with partitioning around medoids.
}
\details{
This method partitions data into the chosen number of cluster on the basis
of the input dissimilarity matrix. It is more robust than k-means because it
minimizes the sum of dissimilarity between cluster centres and points
assigned to the cluster - whereas the k-means approach minimizes the sum of
squared euclidean distances (thus k-means cannot be applied directly on the
input dissimilarity matrix if the distances are not euclidean).
}
\examples{
comat <- matrix(sample(0:1000, size = 500, replace = TRUE, prob = 1/1:1001),
20, 25)
rownames(comat) <- paste0("Site",1:20)
colnames(comat) <- paste0("Species",1:25)

comnet <- mat_to_net(comat)
dissim <- dissimilarity(comat, metric = "all")

clust1 <- nhclu_pam(dissim, n_clust = 2:10, index = "Simpson")
clust2 <- nhclu_pam(dissim, n_clust = 2:15, index = "Simpson")
partition_metrics(clust2, dissimilarity = dissim,
eval_metric = "pc_distance")
partition_metrics(clust2, net = comnet, species_col = "Node2",
                   site_col = "Node1", eval_metric = "avg_endemism")
   
}
\references{
\insertRef{Kaufman2009}{bioregion}
}
\seealso{
\link{nhclu_kmeans}
}
\author{
Boris Leroy (\email{leroy.boris@gmail.com}),
Pierre Denelle (\email{pierre.denelle@gmail.com}) and
Maxime Lenormand (\email{maxime.lenormand@inrae.fr})
}
