% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_RunModelsLoop.R
\name{bm_RunModelsLoop}
\alias{bm_RunModelsLoop}
\alias{bm_RunModel}
\title{Loop to compute all single species distribution models}
\usage{
bm_RunModelsLoop(
  bm.format,
  modeling.id,
  model,
  bm.options,
  metric.eval,
  var.import,
  save.output = TRUE,
  scale.models = TRUE,
  nb.cpu = 1,
  seed.val = NULL,
  do.progress = TRUE
)

bm_RunModel(
  model,
  Data,
  modeling.id = "",
  bm.options,
  calib.lines,
  weights,
  nam,
  dir.name = ".",
  xy = NULL,
  eval.data = NULL,
  eval.xy = NULL,
  metric.eval = c("ROC", "TSS", "KAPPA"),
  var.import = 0,
  save.output = FALSE,
  scale.models = TRUE,
  nb.cpu = 1,
  seed.val = NULL,
  do.progress = TRUE
)
}
\arguments{
\item{bm.format}{a \code{\link{BIOMOD.formated.data}} or \code{\link{BIOMOD.formated.data.PA}} 
object returned by the \code{\link{BIOMOD_FormatingData}} function}

\item{modeling.id}{a \code{character} corresponding to the name (ID) of the simulation set 
(\emph{a random number by default})}

\item{model}{a \code{character} corresponding to the model name to be computed, must be either 
\code{GLM}, \code{GBM}, \code{GAM}, \code{CTA}, \code{ANN}, \code{SRE}, \code{FDA}, 
\code{MARS}, \code{RF}, \code{MAXENT.Phillips}, \code{MAXENT.Phillips.2}}

\item{bm.options}{a \code{\link{BIOMOD.models.options}} object returned by the
\code{\link{BIOMOD_ModelingOptions}} function}

\item{metric.eval}{a \code{vector} containing evaluation metric names to be used, must 
be among \code{ROC}, \code{TSS}, \code{KAPPA}, \code{ACCURACY}, \code{BIAS}, \code{POD}, 
\code{FAR}, \code{POFD}, \code{SR}, \code{CSI}, \code{ETS}, \code{HK}, \code{HSS}, \code{OR}, 
\code{ORSS}}

\item{var.import}{(\emph{optional, default} \code{NULL}) \cr 
An \code{integer} corresponding to the number of permutations to be done for each variable to 
estimate variable importance}

\item{save.output}{(\emph{optional, default} \code{TRUE}) \cr 
A \code{logical} value defining whether all outputs should be saved on hard drive or not 
(\emph{! strongly recommended !})}

\item{scale.models}{(\emph{optional, default} \code{FALSE}) \cr 
A \code{logical} value defining whether all models predictions should be scaled with a 
binomial GLM or not}

\item{nb.cpu}{(\emph{optional, default} \code{1}) \cr 
An \code{integer} value corresponding to the number of computing resources to be used to 
parallelize the single models computation}

\item{seed.val}{(\emph{optional, default} \code{NULL}) \cr 
An \code{integer} value corresponding to the new seed value to be set}

\item{do.progress}{(\emph{optional, default} \code{TRUE}) \cr 
A \code{logical} value defining whether the progress bar is to be rendered or not}

\item{Data}{a \code{data.frame} containing \code{data.species} and \code{data.env.var} slots 
of \code{bm.format} parameter}

\item{calib.lines}{a \code{data.frame} containing \code{data.split.table} slot of 
\code{bm.format} parameter, or an extraction of \code{data.species} slot (for a specific PA 
dataset extracted from \code{PA.table} slot)}

\item{weights}{a \code{vector} of \code{numeric} values corresponding to observation weights 
(one per observation)}

\item{nam}{a \code{character} corresponding to the model to be run (name + run.id)}

\item{dir.name}{(\emph{optional, default} \code{.}) \cr
A \code{character} corresponding to the modeling folder}

\item{xy}{a \code{data.frame} containing \code{coord} slot of \code{bm.format} 
parameter (for a specific PA dataset extracted from \code{PA.table} slot of \code{bm.format} 
parameter)}

\item{eval.data}{a \code{data.frame} containing \code{eval.data.species} and 
\code{eval.data.env.var} slots of \code{bm.format} parameter}

\item{eval.xy}{a \code{data.frame} containing \code{eval.coord} slot of \code{bm.format} 
parameter}
}
\value{
A \code{list} containing for each model a \code{list} containing the following elements :
\itemize{
  \item{\code{model} : }{the name of correctly computed model}
  \item{\code{calib.failure} : }{the name of incorrectly computed model}
  \item{\code{pred} : }{the prediction outputs for calibration data}
  \item{\code{pred.eval} : }{the prediction outputs for validation data}
  \item{\code{evaluation} : }{the evaluation outputs returned by the 
  \code{\link{bm_FindOptimStat}} function}
  \item{\code{var.import} : }{the mean of variables importance returned by the 
  \code{\link{bm_VariablesImportance}} function}
}
}
\description{
This internal \pkg{biomod2} function allows the user to compute all single 
species distribution models (asked by the \code{\link{BIOMOD_Modeling}} function).
}
\seealso{
\code{\link[rpart]{rpart}}, \code{\link[rpart]{prune}}, \code{\link[gbm]{gbm}}, 
\code{\link[MASS]{stepAIC}}, \code{\link[nnet]{nnet}}, \code{\link[earth]{earth}}, 
\code{\link[mda]{fda}}, \code{\link[mda]{mars}}, \code{\link[maxnet]{maxnet}}, 
\code{\link[randomForest]{randomForest}}, 
\code{\link{BIOMOD_ModelingOptions}}, \code{\link{BIOMOD_Modeling}}, 
\code{\link{bm_MakeFormula}}, \code{\link{bm_SampleFactorLevels}}, 
\code{\link{bm_FindOptimStat}}, \code{\link{bm_VariablesImportance}}

Other Secundary functions: 
\code{\link{bm_BinaryTransformation}()},
\code{\link{bm_CVnnet}()},
\code{\link{bm_FindOptimStat}()},
\code{\link{bm_MakeFormula}()},
\code{\link{bm_PlotEvalBoxplot}()},
\code{\link{bm_PlotEvalMean}()},
\code{\link{bm_PlotRangeSize}()},
\code{\link{bm_PlotResponseCurves}()},
\code{\link{bm_PlotVarImpBoxplot}()},
\code{\link{bm_PseudoAbsences}()},
\code{\link{bm_SRE}()},
\code{\link{bm_SampleBinaryVector}()},
\code{\link{bm_SampleFactorLevels}()},
\code{\link{bm_VariablesImportance}()}
}
\author{
Damien Georges
}
\concept{Secundary functions}
\keyword{ANN}
\keyword{CTA}
\keyword{FDA}
\keyword{GAM}
\keyword{GBM}
\keyword{GLM}
\keyword{MARS}
\keyword{MAXENT}
\keyword{RF}
\keyword{SRE}
\keyword{formula}
\keyword{models}
\keyword{options}
