% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_database_all.R
\name{download.database.all}
\alias{download.database.all}
\title{Download all elements of an NCBI databse}
\usage{
download.database.all(db, path)
}
\arguments{
\item{db}{a character string specifying the database that shall be downloaded (selected from \code{\link{listDatabases}}).}

\item{path}{a character string specifying the location (a folder) in which the corresponding
database shall be stored. In case this folder does not exist yet, it will be created.}
}
\description{
The \code{\link{download.database}} functions allows users to retrieve individual
packages of a NCBI database. This function is designed to retrieve the entire database 
selected by the users (hence all packages corresponding to this database).
}
\examples{
\dontrun{
# search for available NCBI databases
  listDatabases(db = "all")
  
# choose database NCBI nr and download compelete database
  download.database.all(name = "nr", path = "nr")
}
}
\author{
Hajk-Georg Drost
}
\seealso{
\code{\link{download.database}}, \code{\link{listDatabases}}
}

