% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{calibrate}
\alias{calibrate}
\title{Calibrate parameters}
\usage{
calibrate(
  data,
  className,
  prop_valid = 0.1,
  nIter = 10,
  distance = "gower",
  weight_space = NULL,
  k_space = NULL,
  print = FALSE
)
}
\arguments{
\item{data}{A dataframe with missing values}

\item{className}{name of the variable that contains the classes}

\item{prop_valid}{proportion of missing values}

\item{nIter}{number of iterations, default = 10}

\item{distance}{distance function used to get the k-nearest neighbors}

\item{weight_space}{vector with the calibration values to test for the weight parameter}

\item{k_space}{vector with the calibration values to test for the number of neighbors}

\item{print}{option to print  the RMSE values of the parameters used for calibration (print = TRUE).}
}
\value{
A dataframe with the imputed data
}
\description{
This function returns a vector with the two parameters requiered by the biokNN method
where the first value is the weighting parameter and the second the number of neighbors
}
\examples{
data(data.example)
calibrate(data.example,
          "class",
          prop_valid = 0.3,
          weight_space = c(0.5, 0.7, 0.9),
          k_space = c(10, 15),
          print = TRUE)
}
