% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/predict_MCMC.R
\name{sample_IsoFit}
\alias{sample_IsoFit}
\title{Random sample of the parameters of a IsoFitInactivation object}
\usage{
sample_IsoFit(iso_fit, times, n_simulations)
}
\arguments{
\item{iso_fit}{An object of class \code{FitInactivationMCMC} as generated
by \code{\link{fit_inactivation_MCMC}}.}

\item{times}{numeric vector specifying the time points when results are
       desired. If \code{NULL}, an equispaced interval between \code{0}
       and the maximum time of the observations with length \code{50}
       is used.}

\item{n_simulations}{a numeric indicating how many Monte Carlo simulations
to perform.}
}
\value{
Returns a list with 4 components.
        \itemize{
             \item par_sample: data frame with the parameter sample.
             \item simulation_model: model key for the simulation
             \item known_pars: parameters of the model known
             \item times: points where the calculation is made.
             }
}
\description{
Function to be called by \code{\link{predict_inactivation_MCMC}}. Produces
a random sample of the parameters adjusted from isothermal experiments.
}
\details{
It is assumed that the parameters follow a Multivariate Normal distribution
with the mean and covariance matrix estimated by the adjustment. The function
produces a random sample using the function \code{\link{mvrnorm}}.
}
\seealso{
\code{\link{mvrnorm}}
}

