% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitMultipleGrowthMCMC_class.R, R/predictMCMC.R
\name{FitMultipleGrowthMCMC}
\alias{FitMultipleGrowthMCMC}
\alias{print.FitMultipleGrowthMCMC}
\alias{plot.FitMultipleGrowthMCMC}
\alias{summary.FitMultipleGrowthMCMC}
\alias{residuals.FitMultipleGrowthMCMC}
\alias{coef.FitMultipleGrowthMCMC}
\alias{vcov.FitMultipleGrowthMCMC}
\alias{deviance.FitMultipleGrowthMCMC}
\alias{fitted.FitMultipleGrowthMCMC}
\alias{predict.FitMultipleGrowthMCMC}
\alias{logLik.FitMultipleGrowthMCMC}
\alias{AIC.FitMultipleGrowthMCMC}
\alias{predictMCMC.FitMultipleGrowthMCMC}
\title{FitMultipleGrowthMCMC class}
\usage{
\method{print}{FitMultipleGrowthMCMC}(x, ...)

\method{plot}{FitMultipleGrowthMCMC}(
  x,
  y = NULL,
  ...,
  add_factor = NULL,
  ylims = NULL,
  label_x = "time",
  label_y1 = "logN",
  label_y2 = add_factor,
  line_col = "black",
  line_size = 1,
  line_type = "solid",
  line_col2 = "black",
  line_size2 = 1,
  line_type2 = "dashed",
  point_size = 3,
  point_shape = 16,
  subplot_labels = "AUTO"
)

\method{summary}{FitMultipleGrowthMCMC}(object, ...)

\method{residuals}{FitMultipleGrowthMCMC}(object, ...)

\method{coef}{FitMultipleGrowthMCMC}(object, ...)

\method{vcov}{FitMultipleGrowthMCMC}(object, ...)

\method{deviance}{FitMultipleGrowthMCMC}(object, ...)

\method{fitted}{FitMultipleGrowthMCMC}(object, ...)

\method{predict}{FitMultipleGrowthMCMC}(object, env_conditions, times = NULL, ...)

\method{logLik}{FitMultipleGrowthMCMC}(object, ...)

\method{AIC}{FitMultipleGrowthMCMC}(object, ..., k = 2)

\method{predictMCMC}{FitMultipleGrowthMCMC}(
  model,
  times,
  env_conditions,
  niter,
  newpars = NULL,
  formula = . ~ time
)
}
\arguments{
\item{x}{an instance of FitMultipleGrowthMCMC.}

\item{...}{ignored}

\item{y}{ignored}

\item{add_factor}{whether to plot also one environmental factor.
If \code{NULL} (default), no environmental factor is plotted. If set
to one character string that matches one entry of x$env_conditions,
that condition is plotted in the secondary axis}

\item{ylims}{A two dimensional vector with the limits of the primary y-axis.}

\item{label_x}{label of the x-axis}

\item{label_y1}{Label of the primary y-axis.}

\item{label_y2}{Label of the secondary y-axis.}

\item{line_col}{Aesthetic parameter to change the colour of the line geom in the plot, see: \code{\link[=geom_line]{geom_line()}}}

\item{line_size}{Aesthetic parameter to change the thickness of the line geom in the plot, see: \code{\link[=geom_line]{geom_line()}}}

\item{line_type}{Aesthetic parameter to change the type of the line geom in the plot, takes numbers (1-6) or strings ("solid") see: \code{\link[=geom_line]{geom_line()}}}

\item{line_col2}{Same as lin_col, but for the environmental factor.}

\item{line_size2}{Same as line_size, but for the environmental factor.}

\item{line_type2}{Same as lin_type, but for the environmental factor.}

\item{point_size}{Size of the data points}

\item{point_shape}{shape of the data points}

\item{subplot_labels}{labels of the subplots according to \code{plot_grid}.}

\item{object}{an instance of FitMultipleGrowthMCMC}

\item{env_conditions}{Tibble with the (dynamic) environmental conditions
during the experiment. It must have one column named 'time' with the
storage time and as many columns as required with the environmental conditions.}

\item{times}{Numeric vector of storage times for the predictions.}

\item{k}{penalty for the parameters (k=2 by default)}

\item{model}{An instance of \link{FitMultipleGrowthMCMC}}

\item{niter}{Number of iterations.}

\item{newpars}{A named list defining new values for the some model parameters.
The name must be the identifier of a model already included in the model.
These parameters do not include variation, so defining a new value for a fitted
parameters "fixes" it. \code{NULL} by default (no new parameters).}

\item{formula}{A formula stating the column named defining the elapsed time in
\code{env_conditions}. By default, . ~ time.}
}
\value{
An instance of \code{\link[=MCMCgrowth]{MCMCgrowth()}}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

The class \link{FitMultipleGrowthMCMC} has been superseded by the top-level
class \link{GlobalGrowthFit}, which provides a unified approach for growth modelling.

Still, it is still returned if the superseded \code{\link[=fit_multiple_growth_MCMC]{fit_multiple_growth_MCMC()}} is called.

It is a subclass of list with the items:
\itemize{
\item fit_results: the object returned by \code{modFit}.
\item best_prediction: a list with the models predictions for each condition.
\item data: a list with the data used for the fit.
\item starting: starting values for model fitting
\item known: parameter values set as known.
\item sec_models: a named vector with the secondary model
for each environmental factor.
}
}
\section{Functions}{
\itemize{
\item \code{print.FitMultipleGrowthMCMC}: print of the model

\item \code{plot.FitMultipleGrowthMCMC}: comparison between the model fitted and the
data.

\item \code{summary.FitMultipleGrowthMCMC}: statistical summary of the fit.

\item \code{residuals.FitMultipleGrowthMCMC}: model residuals. They are returned as a tibble
with 4 columns: time (storage time), logN (observed count),
exp (name of the experiment) and res (residual).

\item \code{coef.FitMultipleGrowthMCMC}: vector of fitted model parameters.

\item \code{vcov.FitMultipleGrowthMCMC}: variance-covariance matrix of the model,
estimated as the variance of the samples from the Markov chain.

\item \code{deviance.FitMultipleGrowthMCMC}: deviance of the model, calculated as the sum of
squared residuals of the prediction with the lowest standard error.

\item \code{fitted.FitMultipleGrowthMCMC}: fitted values of the model. They are returned
as a tibble with 3 columns: time (storage time), exp (experiment
identifier) and fitted (fitted value).

\item \code{predict.FitMultipleGrowthMCMC}: model predictions. They are returned as a tibble
with 3 columns: time (storage time), logN (observed count),
and exp (name of the experiment).

\item \code{logLik.FitMultipleGrowthMCMC}: loglikelihood of the model

\item \code{AIC.FitMultipleGrowthMCMC}: Akaike Information Criterion

\item \code{predictMCMC.FitMultipleGrowthMCMC}: prediction including parameter uncertainty
}}

