% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kl_divergence.R
\name{calc_kl}
\alias{calc_kl}
\title{Calculate KL divergence of features}
\usage{
calc_kl(feature, target_b, len_target, pos_target)
}
\arguments{
\item{feature}{feature vector.}

\item{target_b}{target in bits (as per \code{\link[bit]{as.bit}}).}

\item{len_target}{length of the target vector.}

\item{pos_target}{number of positive cases in the target vector.}
}
\value{
A \code{numeric} vector of length 1 representing Kullback-Leibler divergence 
value.
}
\description{
Computes Kullback-Leibler divergence between features and target vector.
}
\note{
Both \code{target} and \code{features} must be binary, i.e. contain only 0 
and 1 values.

The function was designed to be as fast as possible subroutine of 
\code{\link{calc_criterion}} and might be cumbersome if directly called by a user.
}
\examples{
tar <- sample(0L:1, 100, replace = TRUE)
feat <- sample(0L:1, 100, replace = TRUE)
library(bit) # used to code vector as bit
calc_kl(feat, as.bit(tar), 100, sum(tar))
}
\references{
Kullback S, Leibler RA \emph{On information and sufficiency}. Annals
of Mathematical Statistics 22 (1):79-86, 1951.
}
\seealso{
\code{\link{test_features}}.
Kullback-Leibler divergence is calculated using \code{\link[entropy]{KL.plugin}}.
}
