% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/criterion_distribution.R
\name{criterion_distribution}
\alias{criterion_distribution}
\title{Compute criterion distribution}
\usage{
criterion_distribution(target, feature, graphical_output = FALSE,
  criterion = "ig")
}
\arguments{
\item{target}{\{0,1\}-valued target vector. See Details.}

\item{feature}{\{0,1\}-valued feature vector. See Details.}

\item{graphical_output}{default value is \code{FALSE}, if \code{TRUE}
probability density function is plotted}

\item{criterion}{the criterion used for calculations of distribution.
See list of possible \code{\link{criterions}}.}
}
\value{
A matrix of 3 rows:
\describe{
  \item{1st row:}{possible values of criterion.}
  \item{2nd row:}{probability density function.}
  \item{3rd row:}{cumulative distribution function.}
}
}
\description{
Computes criterion distribution for feature, target under null hypothesis
}
\details{
both \code{target} and \code{feature} vectors may contain only 0 and 1.
}
\examples{
target_feature <- create_feature_target(10, 375, 15, 600)
criterion_distribution(target = target_feature[,1], feature = target_feature[,2],
graphical_output = TRUE)
}
\seealso{
\code{\link{criterions}}.
}
\keyword{distribution}

