\name{EPE}
\encoding{UTF-8}
\alias{EPE}
\title{
Calculation of the Ordinate For an Arbitrary Point on the Preston Curve in the Plane  
}
\description{
\code{EPE} is used to calculate the \emph{y}-value for an arbitrary point on the Preston curve 
that was generated by the explicit Preston equation or one of its simplified versions for a given \emph{x}-value.
}
\usage{
EPE(P, x, simpver = NULL)
}
\arguments{
  \item{P}{the parameters of the explicit Preston equation or one of its simplified versions.}
  \item{x}{the \emph{x}-value used in the explicit Preston equation.}
  \item{simpver}{an optional argument to use the simplified version of the explicit Preston equation.}
}
\details{
When \code{simpver = NULL}, the explicit Preston equation is selected: 
\deqn{ y = b\ \sqrt{1-\left(\frac{x}{a}\right)^2}\left(1+c_{1}\ \frac{x}{a}+c_{2}\left(\frac{x}{a}\right)^2+c_{3}\left(\frac{x}{a}\right)^3\right), }
where \code{P} has five parameters: \eqn{a}, \eqn{b}, \eqn{c_{1}}, \eqn{c_{2}}, and \eqn{c_{3}}.

\eqn{\quad} When \code{simpver = 1}, the simplified version 1 is selected:
\deqn{ y = b\ \sqrt{1-\left(\frac{x}{a}\right)^2}\left(1+c_{1}\ \frac{x}{a}+c_{2}\left(\frac{x}{a}\right)^2\right), }
where \code{P} has four parameters: \eqn{a}, \eqn{b}, \eqn{c_{1}}, and \eqn{c_{2}}.

\eqn{\quad} When \code{simpver = 2}, the simplified version 2 is selected:
\deqn{ y = b\ \sqrt{1-\left(\frac{x}{a}\right)^2}\left(1+c_{1}\ \frac{x}{a}\right), }
where \code{P} has three parameters: \eqn{a}, \eqn{b}, and \eqn{c_{1}}.

\eqn{\quad} When \code{simpver = 3}, the simplified version 3 is selected:
\deqn{ y = b\ \sqrt{1-\left(\frac{x}{a}\right)^2}\left(1+c_{2}\left(\frac{x}{a}\right)^2\right), }
where \code{P} has three parameters: \eqn{a}, \eqn{b}, and \eqn{c_{2}}.
}
\value{
The \eqn{y} values predicted by the explicit Preston equation.
}
\note{
We only considered the upper part of the egg-shape curve in the above expressions because 
the lower part is symmetrical to the upper part around the \emph{x}-axis.  
The mid-line of an egg's profile in \code{\link{EPE}} is aligned to 
the \emph{x}-axis, while the mid-line of an egg's profile in \code{\link{PE}} 
is aligned to the \emph{y}-axis. The \code{\link{EPE}} function has the same parameters, 
\code{P}, as those in the \code{\link{PE}} function. 
The explicit Preston equation is used for calculating an egg's volume and surface area, 
when the parameters, which are saved in the  \code{P} vector, 
are obtained using the \code{\link{fitEPE}} function 
or the \code{\link{lmPE}} function based on the \code{\link{TSE}} function. 
In addition, the values in \code{x} > \eqn{a} (i.e., the first element in \code{P}) 
are forced to be \eqn{a}, and the values in 
\code{x} < \eqn{-a} will be forced to be \eqn{-a}.
}
\author{
Peijian Shi \email{pjshi@njfu.edu.cn}, Johan Gielis \email{johan.gielis@uantwerpen.be}, 
Brady K. Quinn \email{Brady.Quinn@dfo-mpo.gc.ca}.
}
\references{
Lian, M., He, K., Ratkowsky, D.A., Chen, L., Wang, J., Wang, L., Yao, W., Shi, P. (2024) 
Comparison of egg-shape equations using relative curvature measures of nonlinearity. 
\emph{Poultry Science} 103, 104069. \doi{10.1016/j.psj.2024.104069}

Shi, P., Chen, L., Quinn, B.K., Yu, K., Miao, Q., Guo, X., Lian, M., Gielis, J., Niklas, K.J. (2023) 
A simple way to calculate the volume and surface area of avian eggs. 
\emph{Annals of the New York Academy of Sciences} 1524, 118\eqn{-}131. \doi{10.1111/nyas.15000}

Shi, P., Wang, L., Quinn, B.K., Gielis, J. (2023) A new program to estimate the parameters 
of Preston's equation, a general formula for describing the egg shape of birds. \emph{Symmetry} 
15, 231. \doi{10.3390/sym15010231}
}
\seealso{
\code{\link{curveEPE}}, \code{\link{fitEPE}}, \code{\link{PE}}, \code{\link{SurfaceAreaEPE}}, \code{\link{VolumeEPE}}
}
\examples{
  Par3 <- c(4.27, 2.90, 0.0868, 0.0224, -0.0287)
  xx1  <- seq(-4.27, 4.27, by=0.001)
  yy1  <- EPE(P=Par3, x=xx1, simpver=NULL)
  yy2  <- -EPE(P=Par3, x=xx1, simpver=NULL)

  dev.new()
  plot(xx1, yy1, asp=1, type="l", col=4, cex.lab=1.5, cex.axis=1.5,
       xlim=c(-5, 5), ylim=c(-5, 5), 
       xlab=expression(italic(x)), ylab=expression(italic(y)))
  lines(xx1, yy2, col=2) 

  graphics.off() 
}