% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/gbLocation-class.R,
%   R/gbFeature-class.R, R/gbFeatureTable-class.R, R/gbRecord-class.R
\docType{methods}
\name{shift}
\alias{shift}
\alias{shift,gbLocation-method}
\alias{shift,gbFeature-method}
\alias{shift,gbFeatureTable-method}
\alias{shift,gbRecord-method}
\title{Shift the location of features in a GenBank record}
\usage{
shift(x, shift = 0L, split = FALSE, order = TRUE, ...)

\S4method{shift}{gbLocation}(x, shift = 0L, split = FALSE, order = TRUE,
  ...)

\S4method{shift}{gbFeature}(x, shift = 0L, split = FALSE, order = TRUE,
  ...)

\S4method{shift}{gbFeatureTable}(x, shift = 0L, split = FALSE,
  order = FALSE)

\S4method{shift}{gbRecord}(x, shift, split = FALSE, order = TRUE)
}
\arguments{
\item{x}{A \code{\linkS4class{gbFeatureTable}} or
\code{\linkS4class{gbRecord}} instance (gbFeatureTables must 
be complete and include a 'source' field).}

\item{shift}{Number of basepairs (or aa residues) to shift.}

\item{split}{Split features that after the shift extends across the end of
the sequence.}

\item{order}{Reorder features after the shift.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A \code{\linkS4class{gbFeatureTable}} object.
}
\description{
Shift the location of features in a GenBank record
}
\note{
\code{shift} does not currently handle compound locations In a shifted
feature table compound locations get merged.
}
\examples{
load(system.file("extdata", "S_cerevisiae_mito.rda", package = "biofiles"))

## shift the S. cerevisiae mitochondrion such that cytochrome b is the first CDS
cytb <- start(filter(x, product = "^cytochrome b$")[[1]])[1]
x2 <- shift(x, shift = -cytb + 1, split = TRUE)
}
