% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbHeader-class.R
\docType{class}
\name{gbReference-class}
\alias{gbReference-class}
\alias{.gbReference}
\alias{gbReference-class}
\title{Generator object for the \code{"gbReference"} reference class}
\arguments{
\item{...}{List of arguments.}
}
\description{
Generator object for the \code{"gbReference"} reference class

Generates an  object representing a GenBank REFERENCE field.
}
\section{Methods}{

\describe{
\item{\code{to_string(write_to_file = FALSE)}}{Generate a character string representation of a GenBank reference}
}}

\section{Methods}{

\describe{
\item{\code{#new(refline, authors, consrtm, title, journal, pubmed, remark)}:}{
   Create a new \code{\linkS4class{gbReference}} object}
\item{\code{#to_string(write_to_file = FALSE)}:}{
   Create a string representation of for GenBank article citations. }
}
}

\section{Fields}{

\describe{
\item{\code{refline}:}{ Top line of a reference entry.}
\item{\code{authors}:}{ Authors of the citation. Mandatory or \code{consrtm}. }
\item{\code{consrtm}:}{ The collective names of consortiums. Optional.}
\item{\code{title}:}{ Full title of citation. Optional. }
\item{\code{journal}:}{ The journal name, volume, year, and page numbers of
     the citation. Mandatory. }
\item{\code{pubmed}:}{ The PubMed unique identifier for a citation. Optional. }
\item{\code{remark}:}{ The relevance of a citation. Optional. }
}
}

\section{Extends}{
 All reference classes extend and inherit methods from
   \code{"\linkS4class{envRefClass}"}.
}

\examples{
showClass("gbReference")
}
\keyword{classes}
\keyword{internal}
