% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose-usability.R
\name{compose_usability_v1.3.0}
\alias{compose_usability_v1.3.0}
\alias{compose_usability}
\title{Compose BioCompute Object - Usability Domain (v1.3.0)}
\usage{
compose_usability_v1.3.0(text = NULL)

compose_usability(text = NULL)
}
\arguments{
\item{text}{A character vector of free text values that could
improves search-ability, provide specific scientific use cases,
and a description of the function of the object.}
}
\value{
A list of class \code{bco.domain}
}
\description{
The usability domain
(\href{https://github.com/biocompute-objects/BCO_Specification/blob/1.3.0/usability-domain.md}{domain definition}).
}
\examples{
text <- c(
  paste(
    "Identify baseline single nucleotide polymorphisms (SNPs)[SO:0000694]",
    "(insertions)[SO:0000667], and (deletions)[SO:0000045] that correlate",
    "with reduced (ledipasvir)[pubchem.compound:67505836] antiviral drug",
    "efficacy in (Hepatitis C virus subtype 1)[taxonomy:31646]"
  ),
  paste(
    "Identify treatment emergent amino acid (substitutions)[SO:1000002]",
    "that correlate with antiviral drug treatment failure"
  ),
  paste(
    "Determine whether the treatment emergent amino acid",
    "(substitutions)[SO:1000002] identified correlate with treatment",
    "failure involving other drugs against the same virus"
  )
)

text \%>\%
  compose_usability() \%>\%
  convert_json()
}
