% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_bioclim_report.R
\name{bioclim_report}
\alias{bioclim_report}
\title{Function to create individual complete report}
\usage{
bioclim_report(t, p, nam, lat, CC)
}
\arguments{
\item{t}{Monthly average temperature data (12 nueric values).}

\item{p}{Monthly average precipitation data (12 nueric values).}

\item{nam}{Name of the location. It will be used as name of output file}

\item{lat}{Latitude in degrees. For southern latitudes use negative values.}

\item{CC}{Field capacity. It depends on water retention capacity and depth of roots. Use 400 as default value.}
}
\value{
data frame with 20 variables: 'p', 'Tm', 'PET', 'e', 'D', 'S', 's_e_D', 'sum_s', 'c_D_e', 'sum_c', 'Q', 'x', 'E_e', 'D_e', 'Cd', 'T_75', 'B', 'b', 'bl', 'bc'.
}
\description{
This function creates a complete report for a specific location, from temperature and precipitation data series.
}
\examples{
\donttest{
bioclim_report(t = c(10, 11.5, 14, 16.5, 20, 24.5, 27.5, 28, 24.5, 19.5, 14.5, 11),
p = c(55, 73, 84, 58, 33, 23, 2, 2, 28, 66, 94, 71),
lat = 35, nam = 'Seville', CC = 400)
}
}
