% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_audio.R
\name{read_audio}
\alias{read_audio}
\title{Decode audio files}
\usage{
read_audio(filename, time_exp = 1, from = NULL, to = NULL)
}
\arguments{
\item{filename}{a \link{Wave}, WAC or MP3 recording containing animal vocalizations.}

\item{time_exp}{integer. Time expansion factor of the recording.
Set to 1 for real-time recording or above for time expanded recording. Default setting is 1.}

\item{from}{optional. Numeric. Where to start reading the recording, in seconds (s).}

\item{to}{optional. Numeric. Where to end reading the recording, in seconds (s).}
}
\value{
A \link{Wave} object.
}
\description{
Read audio files into a \link{Wave} object. WAV, WAC and MP3 files are
currently supported.
}
\examples{

\donttest{
filepath <- system.file("extdata", "recording.wav", package = "bioacoustics")
read_audio(filepath)
}

}
