% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyquist_velocity.R
\name{nyquist_velocity}
\alias{nyquist_velocity}
\title{Nyquist velocity for a given pulse repetition frequency (PRF)}
\usage{
nyquist_velocity(wavelength, prf1, prf2)
}
\arguments{
\item{wavelength}{radar wavelength in cm}

\item{prf1}{radar pulse repetition frequency in Hz}

\item{prf2}{alternate radar pulse repetition frequency in Hz (for a radar operating in dual-PRF mode)}
}
\value{
Nyquist velocity in m/s.
}
\description{
Calculates the Nyquist velocity given a radar's pulse repetition frequency (PRF)
and wavelength. When specifying two PRFs, the extended Nyquist
velocity is given for a radar using the dual-PRF technique.
}
\examples{
# at C-band (5.3 cm wavelength) and a PRF of 2000 Hz
nyquist_velocity(5.3, 2000)

# extended Nyquist velocity in a dual-PRF scheme
# using 2000 Hz and 1500 Hz PRFs:
nyquist_velocity(5.3, 2000, 1500)
}
