% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppi.R
\name{summary.ppi}
\alias{summary.ppi}
\alias{is.ppi}
\alias{dim.ppi}
\title{Class \code{ppi}: a plan position indicator}
\usage{
\method{summary}{ppi}(object, ...)

is.ppi(x)

\method{dim}{ppi}(x)
}
\arguments{
\item{object}{Object of class \code{ppi}.}

\item{...}{Additional arguments affecting the summary produced.}

\item{x}{Object of class \code{ppi}.}
}
\value{
For \code{is.ppi}: \code{TRUE} if its argument is of
class \code{ppi}.

For \code{dim.ppi}: dimensions of the ppi.
}
\description{
Class \code{ppi} for a plan position indicator, and its associated R base
functions.
}
\details{
\code{ppi} objects are generated from elevation scans (\code{scan} objects)
with \link{project_as_ppi} or from polar volumes with \link{integrate_to_ppi},
producing projections of the radar data onto the earth's surface.

An object of class \code{ppi} is a list containing:
\describe{
 \item{\code{data}}{an object of class \link[sp]{SpatialGridDataFrame}
   containing the georeferenced data. Commonly available parameters are:
    \describe{
     \item{"\code{DBZH}", "\code{DBZ}"}{(Logged) reflectivity factor [dBZ]}
     \item{"\code{TH}", "\code{T}"}{(Logged) uncorrected reflectivity factor [dBZ]}
     \item{"\code{VRADH}", "\code{VRAD}"}{Radial velocity [m/s]. Radial
       velocities towards the radar are negative, while radial velocities
       away from the radar are positive}
     \item{"\code{RHOHV}"}{Correlation coefficient [unitless]. Correlation
       between vertically polarized and horizontally polarized reflectivity
       factor}
     \item{"\code{PHIDP}"}{Differential phase [degrees]}
     \item{"\code{ZDR}"}{(Logged) differential reflectivity [dB]}
       }
 }
 \item{\code{geo}}{geographic data, a list with:
    \describe{
     \item{\code{lat}}{latitude of the radar [decimal degrees]}
     \item{\code{lon}}{longitude of the radar [decimal degrees]}
     \item{\code{height}}{height of the radar
       antenna [meters above sea level]}
     \item{\code{elangle}}{radar beam elevation [degrees]}
     \item{\code{rscale}}{range bin size [m]}
     \item{\code{ascale}}{azimuth bin size [deg]}
    }
    The \code{geo} element of a 'scan' object is a copy of the \code{geo}
    element of its parent scan or scan parameter.
  }
}
}
\examples{
# load example scan object
data(example_scan)

# calculate ppi object
example_ppi <- project_as_ppi(example_scan)

# print summary info:
example_ppi

# verify exampl_ppi is a ppi object:
is.ppi(example_ppi)

# ppi object dimensions:
dim(example_ppi)
}
