% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbz_eta.R
\name{dbz_to_eta}
\alias{dbz_to_eta}
\title{Convert reflectivity factor to reflectivity}
\usage{
dbz_to_eta(dbz, wavelength, K = 0.93)
}
\arguments{
\item{dbz}{reflectivity factor in dBZ}

\item{wavelength}{radar wavelength in cm}

\item{K}{norm of the complex refractive index of water}
}
\value{
reflectivity in cm^2/km^3
}
\description{
Convert reflectivity factor to reflectivity
}
\examples{
# calculate eta for a 7 dBZ reflectivity factor at C-band:
dbz_to_eta(7, 5)

# calculate eta for a 7 dBZ reflectivity factor at S-band:
dbz_to_eta(7, 10)

# calculate animal density for a 5 dBZ reflectivity
# factor at C-band and S-band, assuming a
# 11 cm^2 radar cross section per animal:
dbz_to_eta(7, 5) / 11 # C-band
dbz_to_eta(7, 10) / 11 # S-band
}
