% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regularize_vpts.R
\name{regularize_vpts}
\alias{regularize_vpts}
\title{Regularize a time series of vertical profiles (\code{vpts}) on a
regular time grid}
\usage{
regularize_vpts(ts, interval = "auto", date_min = ts$daterange[1],
  date_max = ts$daterange[2], units = "mins", fill = FALSE,
  verbose = TRUE)
}
\arguments{
\item{ts}{An object inheriting from class \code{vpts}, see
\code{\link[=summary.vpts]{vpts}} for details.}

\item{interval}{Time interval grid to project on. When '\code{auto}' the
median interval in the time series is used.}

\item{date_min}{Start time of the projected time series, as a POSIXct object.
Taken from \code{ts} when '\code{auto}'.}

\item{date_max}{End time of the projected time series, as a POSIXct object.
Taken from \code{ts} when '\code{auto}'.}

\item{units}{Optional units of \code{interval}, one of 'secs', 'mins',
'hours','days', 'weeks'. Defaults to 'mins'.}

\item{fill}{Logical, whether to fill missing timesteps with the values of
the closest neighboring profile.}

\item{verbose}{Logical, when \code{TRUE} prints text to console.}
}
\value{
An object of class \code{vpts} with regular time steps.
}
\description{
Projects objects of class \code{vpts} on a regular time grid
}
\details{
Irregular time series of profiles are typically aligned on a
regular time grid with the expected time interval at which a radar provides
data. Empty profiles with only missing data values will be inserted at
time stamps of the regular time grid that have no matching profile in the
irregular time series.

In plots of regular time series (see \code{\link{plot.vpts}}) temporal gaps of
missing profiles (e.g. due to radar down time) become visible. In irregular
time series data points in the plot are carried through until the time series
continues, and temporal data gaps are filled up visually.
}
\examples{
# start form example vpts object:
ts <- example_vpts
# regularize the time series on a 5 minute interval grid
tsRegular <- regularize_vpts(ts, interval = 5)
}
