% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.R
\name{tidyverse}
\alias{tidyverse}
\alias{select.scan}
\title{Tidyverse methods for bioRad objects}
\usage{
select.scan(.data, ...)
}
\arguments{
\item{.data}{data object of class \code{scan} or \code{pvol}}

\item{...}{other arguments}
}
\description{
Tidyverse methods for bioRad objects, currently only select is implemented. When \code{dplyr} or \code{tidyverse} is loaded the \code{select} method can be used to select parameters.
}
\examples{
if (require(dplyr, quietly = TRUE)) {
# locate example volume file:
pvolfile <- system.file("extdata", "volume.h5", package = "bioRad")

# load the file:
example_pvol <- read_pvolfile(pvolfile)
pvol_selected<-select(example_pvol, DBZH, ZDR) 
# Only selected parameters are retained in the pvol
get_scan(pvol_selected, 1.5)
# Also a series of parameters in a scan can be selected
select(get_scan(example_pvol, 2.5), VRADH:ZDR)
}
}
\keyword{internal}
