% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgtp.R
\name{rgtp}
\alias{rgtp}
\title{Simulation of generalized Thomas process}
\usage{
rgtp(
  kappa,
  omega,
  lambda,
  theta,
  win = owin(c(0, 1), c(0, 1)),
  nsim = 1,
  expand = 4 * omega,
  C = NULL
)
}
\arguments{
\item{kappa}{Intensity of cluster centers.}

\item{omega}{Standard deviation of normal distribution specifying the clusters spread.}

\item{lambda}{Parameter of generalised Poisson distribution controlling over or under dispersion.}

\item{theta}{Parameter of generalised Poisson distribution controlling the mean number of points in a cluster.}

\item{win}{Window in which to simulate the pattern. An object of class \emph{owin} or something acceptable to \emph{as.owin}.}

\item{nsim}{Number of simulations.}

\item{expand}{The size of expansion of window to simulate the centers of clusters.}

\item{C}{Process of center points.}
}
\value{
A list(X, C), where \emph{X} is Generalized Poisson process, and \emph{C} is Process of cluster centers for Generalized Poisson process.
}
\description{
Simulation of generalized Thomas process.
}
\examples{

library(spatstat)
kappa = 10
omega = .1
lambda= .5
theta = 10

X = rgtp(kappa, omega, lambda, theta, win = owin(c(0, 1), c(0, 1)))
plot(X$X)
plot(X$C)

}
