\name{binomCI-package}
\alias{binomCI-package}
\docType{package}
\title{
Confidence Intervals for a Binomial Proportion.
}
\description{
Functions to compute 12 confidence intervals for a binomial proportion.
}
\details{
\tabular{lll}{
Package: \tab binomCI\cr
Type: \tab Package\cr
Version: \tab 1.2\cr
Date: \tab 2024-11-25\cr
License: \tab GPL-2\cr
}
}
\author{
Michail Tsagris \email{mtsagris@uoc.gr}.
}

\section{Maintainers}{
Michail Tsagris \email{mtsagris@uoc.gr}.
}

\references{
Agresti, A. & Caffo, B. (2000). Simple and effective confidence intervals for proportions and differences of proportions result from adding two successes and two failures. The American Statistician, 54(4), 280--288.

Agresti, A. & Coull, B. A. (1998). Approximate is better than "exact" for interval estimation of binomial proportions. The American Statistician, 52(2): 119--126.

Brown, L. D., Cai, T. T. & DasGupta, A. (2001). Interval estimation for a binomial proportion. Statistical Science, 16(2): 101-133.

Brown, L. D., Cai, T. T. & DasGupta, A. (2002). Confidence intervals for a binomial proportion and asymptotic expansions. The Annals of Statistics, 30(1): 160-201.

Cameron, E. (2011). On the estimation of confidence intervals for binomial population proportions in astronomy: the simplicity and superiority of the Bayesian approach. Publications of the Astronomical Society of Australia, 28(2): 128--139.

Newcombe, R. G. (1998). Two-sided confidence intervals for the single proportion: comparison of seven methods. Statistics in Medicine, 17(8): 857--872.

Pan, W. (2002). Approximate confidence intervals for one proportion and difference of two proportions. Computational statistics & Data Analysis, 40(1): 143-157.

Pires, A. M. & Amado, C. (2008). Interval estimators for a binomial proportion: Comparison of twenty methods. REVSTAT-Statistical Journal, 6(2): 165-197.

Ranucci, G. (2009). Binomial and ratio-of-Poisson-means frequentist confidence intervals applied to the error evaluation of cut efficiencies. arXiv preprint arXiv:0901.4845.

Sauro, J. & Lewis, J. R. (2005, September). Estimating completion rates from small samples using binomial confidence intervals: comparisons and recommendations. In Proceedings of the Human Factors and Ergonomics Society Annual Meeting (Vol. 49, No. 24, pp. 2100-2103). Sage CA: Los Angeles, CA: SAGE Publications.

Somerville, M. C. & Brown, R. S. (2013). Exact likelihood ratio and score confidence intervals for the binomial proportion. Pharmaceutical Statistics, 12(3): 120-128.

Thulin, Mans. The cost of using exact confidence intervals for a binomial proportion. (2014): 817-840.  Electronic Journal of Statistics 8(1): 817-840.

Vollset, S. E. (1993). Confidence intervals for a binomial proportion. Statistics in Medicine, 12(9): 809-824.
}


\note{
I would like to express my acknowledgements to Marc Girondot for spotting an error in the "Wilson" method in two extreme cases, when \eqn{x=1} and when \eqn{n-x=1}. He also proposed a modification that exists in the package "Hmisc" and the relevant paper to cite is Agresti & Coull (1998).
}


