% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binneRlyse.R
\name{binneRlyse}
\alias{binneRlyse}
\title{binneRlyse}
\usage{
binneRlyse(files, info, parameters = binParameters(), verbose = T)
}
\arguments{
\item{files}{character vector of file paths to use for spectral binning}

\item{info}{tibble containing sample information}

\item{parameters}{object of class BinParameters containing parameters for spectral binning}

\item{verbose}{show console output}
}
\description{
perform spectral binning.
}
\examples{
\dontrun{
files <- metaboData::filePaths('FIE-HRMS','BdistachyonEcotypes')

info <- metaboData::runinfo('FIE-HRMS','BdistachyonEcotypes')

analysis <- binneRlyse(files, 
                       info, 
                       parameters = binParameters(detectInfusionScans(files)))
   }
}
