% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database-stats.R
\name{bike_daily_trips}
\alias{bike_daily_trips}
\title{Extract daily trip counts for all stations}
\usage{
bike_daily_trips(bikedb, city, station, member, birth_year, gender,
  standardise = FALSE)
}
\arguments{
\item{bikedb}{A string containing the path to the SQLite3 database.
If no directory specified, it is presumed to be in \code{tempdir()}.}

\item{city}{City for which trips are to be counted - mandatory if database
contains data for more than one city}

\item{station}{Optional argument specifying bike station for which trips are
to be counted}

\item{member}{If given, extract only trips by registered members
(\code{member = 1} or \code{TRUE}) or not (\code{member = 0} or \code{FALSE}).}

\item{birth_year}{If given, extract only trips by registered members whose
declared birth years equal or lie within the specified value or values.}

\item{gender}{If given, extract only records for trips by registered
users declaring the specified genders (\code{f/m/.} or \code{2/1/0}).}

\item{standardise}{If TRUE, daily trip counts are standardised to the
relative numbers of bike stations in operation for each day, so daily trip
counts are increased during (generally early) periods with relatively fewer
stations, and decreased during (generally later) periods with more stations.}
}
\value{
A \code{data.frame} containing daily dates and total numbers of trips
}
\description{
Extract daily trip counts for all stations
}
\examples{
\dontrun{
bike_write_test_data () # by default in tempdir ()
# dl_bikedata (city = 'la', data_dir = '.') # or download some real data!
store_bikedata (data_dir = tempdir (), bikedb = 'testdb')
# create database indexes for quicker access:
index_bikedata_db (bikedb = 'testdb')

bike_daily_trips (bikedb = 'testdb', city = 'ny')
bike_daily_trips (bikedb = 'testdb', city = 'ny', member = TRUE)
bike_daily_trips (bikedb = 'testdb', city = 'ny', gender = 'f')
bike_daily_trips (bikedb = 'testdb', city = 'ny', station = '173',
                  gender = 1)

bike_rm_test_data ()
bike_rm_db ('testdb')
# don't forget to remove real data!
# file.remove (list.files ('.', pattern = '.zip'))
}
}
