% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/procrustes.R
\name{procrustes}
\alias{procrustes}
\title{Procrustes transform}
\usage{
procrustes(Y, X, n_iter_max = 1000, epsilon_min = 1e-07)
}
\arguments{
\item{Y}{Reference matrix.}

\item{X}{Matrix to transform (\code{ncol(X) >= ncol(Y)}).}

\item{n_iter_max}{Maximum number of iterations. Default is \code{1000}.}

\item{epsilon_min}{Convergence criterion. Default is \code{1e-7}.}
}
\value{
Object of class "procrustes", a list with the following elements:
\itemize{
\item \verb{$R}: the rotation matrix to apply to \code{X},
\item \verb{$rho}: the scaling coefficient to apply to \code{X},
\item \verb{$c}: the column centering to apply to the resulting matrix,
\item \verb{$diff}: the average difference between \code{Y} and \code{X} transformed.
}

You can use method \code{predict()} to apply this transformation to other data.
}
\description{
Procrustes transform Y = pXR (after centering), where p is a scaling
coefficient and R is a rotation matrix that minimize ||Y - pXR||_F.
}
\examples{
A <- matrix(rnorm(200), ncol = 20)
B <- matrix(rnorm(length(A)), nrow = nrow(A))

proc <- procrustes(B, A)
str(proc)
plot(B, predict(proc, A)); abline(0, 1, col = "red")

}
