% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigtcr_func.R
\name{get.gap.pval}
\alias{get.gap.pval}
\title{Comparison of Bivariate CCIF}
\usage{
get.gap.pval(obs.y, event, v, tau = Inf, comp.event = c(1, 2), np = 1000,
  Kt = function(x) {     1 })
}
\arguments{
\item{obs.y}{\eqn{Y}: time to failure events or censoring}

\item{event}{0: censored; \eqn{1, \ldots J}: type of failure events}

\item{v}{Time to the first failure event (e.g. disease recurrence)}

\item{tau}{Conditioning time \eqn{\tau} under which the CCIF is defined}

\item{comp.event}{Failure events for CCIF comparison}

\item{np}{Number of permutations}

\item{Kt}{A weight function that takes one parameter \eqn{t} and return the
weight for \eqn{t}. Default weight function is constant \eqn{1}}
}
\value{
P-value of the hypothesis test \eqn{H_0: H_j = H_k = \ldots = H_l}.
}
\description{
Compare the bivariate CCIF of different failure typess by applying the technique of
permutation test. See \code{\link{bigtcr-package}}.
}
\examples{

gap.pval <- get.gap.pval(pancancer$obs.y, pancancer$min.type, pancancer$v,
                         tau=120, comp.event=c(1,2), np=20);

}

