% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external-software.R
\name{snp_plinkRmSamples}
\alias{snp_plinkRmSamples}
\title{Remove samples}
\usage{
snp_plinkRmSamples(plink.path = download_plink(), bedfile.in, bedfile.out,
  df.or.files, col.family.ID = 1, col.sample.ID = 2, ...)
}
\arguments{
\item{plink.path}{Path to the executable of PLINK 1.9. Default downloads it.}

\item{bedfile.in}{Path to the input bedfile.}

\item{bedfile.out}{Path to the output bedfile.}

\item{df.or.files}{Either
\itemize{
\item A \code{data.frame},
\item A character vector of file names where to find at the information you want.
You should have one column for family IDs and one for sample IDs.
}}

\item{col.family.ID}{Index of the column containing the
family IDs to match with those of the study. Default is the second one.}

\item{col.sample.ID}{Index of the column containing the
sample IDs to match with those of the study. Default is the first one.}

\item{...}{Any additional parameter to pass to \link[data.table:fread]{fread}.
Particularly, option \code{header = FALSE} is sometimes needed.}
}
\value{
The path of the new bedfile.
}
\description{
Create new \emph{bed}/\emph{bim}/\emph{fam} files by removing samples with PLINK.
}
\seealso{
\link{download_plink}
}
