% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decoupling.r
\name{longwave.conductance}
\alias{longwave.conductance}
\title{Longwave Radiative Transfer Conductance of the Canopy}
\usage{
longwave.conductance(Tair, LAI, constants = bigleaf.constants())
}
\arguments{
\item{Tair}{Air temperature (deg C)}

\item{LAI}{Leaf area index (m2 m-2)}

\item{constants}{Kelvin - conversion degree Celsius to Kelvin \cr
sigma - Stefan-Boltzmann constant (W m-2 K-4) \cr
cp - specific heat of air for constant pressure (J K-1 kg-1)}
}
\value{
\item{Gr -}{longwave radiative transfer conductance of the canopy (m s-1)}
}
\description{
Longwave Radiative Transfer Conductance of the Canopy
}
\details{
the following formula is used (Martin, 1989):

         \deqn{Gr = 4 \sigma Tair^3 LAI / cp}
}
\examples{
longwave.conductance(25,seq(1,8,1))            
                 
}
\references{
Martin P., 1989: The significance of radiative coupling between
            vegetation and the atmosphere. Agricultural and Forest Meteorology 49, 45-53.
}
