% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{yule}
\alias{yule}
\title{Compute Yule's Phi-coefficient}
\usage{
yule(z_star, z)
}
\arguments{
\item{z_star}{a true block membership}

\item{z}{an estimated block membership}
}
\value{
Real value of Yule's Phi-coefficient between the true and estimated block membership is returned.
}
\description{
This function computes Yule's Phi-coefficient between the true and estimated block membership (its definition can be found here \url{https://en.wikipedia.org/wiki/Phi_coefficient}).
In this context, the Phi Coefficient is a measure of association between two group membership vectors.
}
\examples{
data(toyNet)
yule(z_star = toyNet\%v\% "block",
                  z = sample(c(1:4),size = 200,replace = TRUE))
                  
}
