% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigdist_accessors.R
\name{bigdist_extract}
\alias{bigdist_extract}
\title{Extract parts of bigdist}
\usage{
bigdist_extract(x, i, j, k, product = "outer")
}
\arguments{
\item{x}{Object of class 'bigdist'}

\item{i}{(integer vector) row positions}

\item{j}{(integer vector) column positions}

\item{k}{(integer vector) positions}

\item{product}{(string) One among: 'inner', 'outer'(default)}
}
\value{
A matrix or vector of distances when product is 'outer' and 'inner'
  respectively
}
\description{
Extract parts of bigdist
}
\details{
In k-mode, both i and j should be missing and k should not be
  missing. In ij-mode, k should be missing and both i and j are optional. If
  i or j are missing, they are interpreted as all values of i or j (similar
  to matrix or dataframe subsetting).
}
\examples{
set.seed(1)
amat <- matrix(rnorm(1e3), ncol = 10)
td   <- tempdir()
temp <- bigdist(mat = amat, file = file.path(td, "temp_ex6"))
bigdist_extract(temp, 1, 2)
bigdist_extract(temp, 1:2, 3:4)
bigdist_extract(temp, 1:2, 3:4, product = "inner")
dim(bigdist_extract(temp, 1:2,))
dim(bigdist_extract(temp, , 3:4))
}
